/* $Id: efosc_extract.h,v 1.1 2009-07-09 15:13:17 cizzo Exp $
 *
 * This file is part of the EFOSC Library
 * Copyright (C) 2009 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2009-07-09 15:13:17 $
 * $Revision: 1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef EFOSC_EXTRACT_H
#define EFOSC_EXTRACT_H

#include <efosc_star.h>
#include <efosc_image.h>

#include <cpl.h>

CPL_BEGIN_DECLS

typedef struct _extract_method extract_method;

typedef struct efosc_extract_sky_stats {
    double mean, median, rms;
} efosc_extract_sky_stats;

void 
efosc_extract_define_parameters(             cpl_parameterlist *parameters, 
                                            const char *context);

bool
efosc_extract_check_sex_flag(                unsigned int    sex_flag);

bool
efosc_extract_check_sex_star(                const efosc_star *star,
                                            const cpl_image *ref_img);


extract_method *
efosc_extract_method_new(                    const cpl_parameterlist *parameters,
                                            const char *context);

void
efosc_extract_method_delete(                 extract_method **em);

efosc_star_list *
efosc_extract(                               const efosc_image *image, 
                                            const efosc_setting *setting,
                                            const extract_method *em,
                                            efosc_extract_sky_stats *sky_stats,
                                            cpl_image **background,
                                            cpl_table **extracted_sources);


CPL_END_DECLS

#endif
