/* $Id: efosc_pattern.h,v 1.1 2009-07-10 13:11:55 cizzo Exp $
 *
 * This file is part of the EFOSC Library
 * Copyright (C) 2009 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cizzo $
 * $Date: 2009-07-10 13:11:55 $
 * $Revision: 1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef EFOSC_PATTERN_H
#define EFOSC_PATTERN_H

#include <efosc_point.h>

#include <stdbool.h>

typedef struct _efosc_pattern efosc_pattern;

#undef LIST_ELEM
#define LIST_ELEM efosc_pattern
#include <list.h>

efosc_pattern *efosc_pattern_new(const efosc_point *ref,
                               const efosc_point *p1,
                               const efosc_point *p2,
                               double sigma);

efosc_pattern_list *
efosc_pattern_new_from_points(struct efosc_point_list *points,
			     double tolerance,
			     double sigma);

void
efosc_pattern_delete(efosc_pattern **p);

void efosc_pattern_print(const efosc_pattern *p);

const efosc_point *
efosc_pattern_get_ref(const efosc_pattern *p);

double efosc_pattern_get_scale(const efosc_pattern *p,
                              const efosc_pattern *q);
double efosc_pattern_get_angle(const efosc_pattern *p,
                              const efosc_pattern *q);

void efosc_pattern_get_shift(const efosc_pattern *p,
			    const efosc_pattern *q,
			    double *shift_x,
			    double *shift_y);

double efosc_pattern_distsq(const efosc_pattern *p,
                           const efosc_pattern *q);

double efosc_pattern_dist_per_error(const efosc_pattern *p,
				   const efosc_pattern *q);

void efosc_pattern_error(const efosc_pattern *p,
			double *dr2,
			double *dtheta);

#endif
