from edps import classification_rule

from . import efosc_keywords as kwd
from . import efosc_rules as rules

# Common classification
is_efosc = {kwd.instrume: "EFOSC"}
is_science = {**is_efosc, kwd.dpr_catg: "SCIENCE"}
is_calibration = {**is_efosc, kwd.dpr_catg: "CALIB"}
is_image_calibration = {**is_efosc, kwd.dpr_catg: "CALIB", kwd.dpr_tech: "IMAGE"}
is_spectra_calibration = {**is_efosc, kwd.dpr_catg: "CALIB", kwd.dpr_tech: "SPECTRUM"}
is_image_science = {**is_efosc, kwd.dpr_catg: "SCIENCE", kwd.dpr_tech: "IMAGE"}
is_spectrum_science = {**is_efosc, kwd.dpr_catg: "SCIENCE", kwd.dpr_tech: "SPECTRUM"}

# CLASSIFICATION RULES
# common calibrations
bias_class = classification_rule("BIAS", rules.is_bias)
MASTER_BIAS = classification_rule("MASTER_BIAS", {**is_efosc, kwd.pro_catg: "MASTER_BIAS"})

# static calibrations for spectroscopy
GRISM_TABLE = classification_rule("GRISM_TABLE", {**is_efosc, kwd.pro_catg: "GRISM_TABLE"})
LINE_CATALOG = classification_rule("LINE_CATALOG", {**is_efosc, kwd.pro_catg: "LINE_CATALOG"})
SKYLINE_CATALOG = classification_rule("MASTER_SKYLINECAT", {**is_efosc, kwd.pro_catg: "MASTER_SKYLINECAT"})
STD_FLUX_TABLE_SPC = classification_rule("STD_FLUX_TABLE_SPC", {**is_efosc, kwd.pro_catg: "STD_FLUX_TABLE"})
EXTINCTION_TABLE = classification_rule("EXTINCT_TABLE", {**is_efosc, kwd.pro_catg: "EXTINCT_TABLE"})

# static calibrations for imaging
PHOTOMETRIC_TABLE = classification_rule("PHOT_TABLE", {**is_efosc, kwd.pro_catg: "PHOT_TABLE"})
STD_FLUX_TABLE_IMG = classification_rule("FLX_STD_IMG", {**is_efosc, kwd.pro_catg: "FLX_STD_IMG"})
# IMAGING raw data and products
skyflat_img_class = classification_rule("SKY_FLAT_IMG", {**is_image_calibration, kwd.dpr_type: "SKY,FLAT"})
MASTER_SKYFLAT_IMG = classification_rule("MASTER_SKY_FLAT_IMG", {**is_efosc, kwd.pro_catg: "MASTER_SKY_FLAT_IMG"})
stdandard_imging_class = classification_rule("STANDARD_IMG", {**is_image_science, kwd.dpr_type: "STD"})
science_img_class = classification_rule("SCIENCE_IMG", rules.is_science_img)

# SPECTROSCOPY raw data
# flat fields
cls_screen_flat_lss = classification_rule("SCREEN_FLAT_MOS", rules.is_screen_flat_lss)
cls_screen_flat_mos = classification_rule("SCREEN_FLAT_MOS", rules.is_screen_flat_mos)
# wavecal
cls_lamp_lss = classification_rule("LAMP_MOS", rules.is_lamp_lss)
cls_lamp_mos = classification_rule("LAMP_MOS", rules.is_lamp_mos)
# standard stars
cls_std_spectra = classification_rule("STANDARD_MOS", {**is_spectrum_science, kwd.dpr_type: "STD"})

# science
cls_sci = classification_rule("SCIENCE_MOS", {**is_spectrum_science, "dpr.type": "OBJECT"})
# products
# LSS
pcls_master_norm_flat_lss = classification_rule("MASTER_NORM_FLAT_MOS",
                                                {**is_efosc, kwd.pro_catg: "MASTER_NORM_FLAT_MOS"})
pcls_disp_coeff_lss = classification_rule("DISP_COEFF_MOS", {**is_efosc, kwd.pro_catg: "DISP_COEFF_MOS"})
pcls_slit_location_lss = classification_rule("SLIT_LOCATION_MOS", {**is_efosc, kwd.pro_catg: "SLIT_LOCATION_MOS"})
pcls_specphot_table = classification_rule("SPECPHOT_TABLE", {**is_efosc, kwd.pro_catg: "SPECPHOT_TABLE"})
# MOS
pcls_master_norm_flat_mos = classification_rule("MASTER_NORM_FLAT_MOS",
                                                {**is_efosc, kwd.pro_catg: "MASTER_NORM_FLAT_MOS"})
pcls_disp_coeff_mos = classification_rule("DISP_COEFF_MOS", {**is_efosc, kwd.pro_catg: "DISP_COEFF_MOS"})
pcls_slit_location_mos = classification_rule("SLIT_LOCATION_MOS", {**is_efosc, kwd.pro_catg: "SLIT_LOCATION_MOS"})
pcls_curv_coeff_mos = classification_rule("CURV_COEFF_MOS", {**is_efosc, kwd.pro_catg: "CURV_COEFF_MOS"})
