from adari_core.data_libs.master_rawdisp import MasterRawdispReport
import os
from .hawki_utils import HawkiSetupInfo, HawkiReportMixin


class HawkiRawdispReport(HawkiReportMixin, MasterRawdispReport):
    def __init__(self):
        super().__init__("hawki_rawdisp")

        channels = ["CHIP1.INT1", "CHIP2.INT1", "CHIP3.INT1", "CHIP4.INT1"]
        self.raw_extensions = {c: c for c in channels}

        self.extensions = []
        ## The content of this dictionary is always: {"SOF_TAG" : "recipe"}
        self.tasks = {
            "DARK": "dark",
            #
            "FLAT_TWILIGHT": "flat",
            #
            "OFF_RAW": "detlin",
            "ON_RAW": "detlin",
            #
            "STD": "std",
        }
        # For each keyword recipe in self.tasks, select a number of raw frames:
        # DARK: select the first frame

        self.select_raw_files = {
            "DARK": [1],
            "FLAT_TWILIGHT": [1],
            "OFF_RAW": [1],
            "ON_RAW": [1],
            "STD": [1],
        }

        self.task_scaling = {}
        self.setup_info = HawkiSetupInfo

    def parse_sof(self):
        # we building multiple report sets, so we append multiple reports to file_lists
        # get a list of tags
        tags = list(self.tasks.keys())
        raw_count = dict.fromkeys(tags, 0)

        file_lists = []
        for filename, catg in self.inputs:
            if catg in tags:
                if filename is not None:
                    raw_count[catg] += 1
                    if raw_count[catg] in self.select_raw_files[catg]:
                        print(catg, raw_count[catg], self.select_raw_files[catg])
                        file_lists.append({"filename": filename})
                        self.sof_tag.append(catg)
        return file_lists

    def get_extensions(self):
        """Find the data extensions required for each MUSE files.

        Description
        -----------
        After the SOF has been parsed, this method iterates over the different
        HDUS files to find which extension(s) contains the data.
        """
        new_hdus_list = []
        new_sof_tag = []
        for i, filedict in enumerate(self.hdus):
            hdul = filedict["filename"]
            all_hdu_names = [hdu.name for hdu in hdul]

            for chip_name in self.raw_extensions.keys():
                if chip_name in all_hdu_names:
                    new_hdus_list.append(filedict)
                    new_sof_tag.append(self.sof_tag[i])
                    self.extensions.append(chip_name)

        self.hdus = new_hdus_list
        self.sof_tag = new_sof_tag

    def generate_panels(self, **kwargs):
        panels = {}
        self.get_extensions()
        new_panels = super().generate_panels(ext=self.extensions, **kwargs)
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # Alter the cut pos, or remove CutPlot(s) completely,
            # depending on task name
            try:
                task_name = panel_descr["task_name"]
            except KeyError:
                raise RuntimeError(
                    "A report has been created by "
                    "MasterRawdispReport that did "
                    "not come back with a task name "
                    "attached!"
                )
            panel_descr["report_name"] = "hawki_rawdisp_{}_{}_{}_{}".format(
                task_name,
                self.raw_extensions[self.extensions[i]],
                self.sof_tag[i].lower(),
                os.path.basename(panel_descr["filename"]),
            )
            panel_descr["report_description"] = (
                f"HAWKI rawdisp panel - "
                f"{panel_descr['task_name']}, "
                f"{panel_descr['tag']}, "
                f"{os.path.basename(panel_descr['filename'])}, "
                f"{panel_descr['ext']}"
            )

        panels = {**panels, **new_panels}

        return panels


rep = HawkiRawdispReport()
