from edps import match

from . import hawki_keywords as kwd


def is_hawki(f):
    return f[kwd.instrume] == "HAWKI"


def is_calib(f):
    return is_hawki(f) and f[kwd.dpr_catg] == "CALIB"


def is_test(f):
    return is_hawki(f) and f[kwd.dpr_catg] == "TEST"


def is_acquisition(f):
    return is_hawki(f) and f[kwd.dpr_catg] == "ACQUISITION"


def is_image(f):
    return f[kwd.dpr_tech] == "IMAGE"


def is_calib_or_test(f):
    return is_calib(f) or is_test(f)


def is_calib_image(f):
    return is_calib(f) and is_image(f)


def is_basic_dark(f):
    return is_calib_image(f) and f[kwd.dpr_type] == "DARK" and f[kwd.tpl_nexp] > 2


def is_dark(f):
    return is_basic_dark(f) and f[kwd.det_ndit] != 1 and f[kwd.tpl_id] == "HAWKI_img_cal_Darks"


def is_dark_windowed(f):
    return is_basic_dark(f) and f[kwd.tpl_id] == "HAWKI_img_cal_WinDarks"


def is_detnoise_dark(f):
    return is_basic_dark(f) and f[kwd.det_ndit] == 1 and f[kwd.tpl_id] == 'HAWKI_img_cal_Darks'


def is_sky_flat(f):
    return is_calib_image(f) and f[kwd.dpr_type] == "FLAT" and f[kwd.tpl_nexp] > 2 \
        and (f[kwd.tpl_id] == 'HAWKI_img_cal_TwFlats' or f[kwd.tpl_id] == 'HAWKI_img_cal_SkyFlats')


def is_sky_flat_windowed(f):
    return is_calib(f) and f[kwd.dpr_tech] == "IMAGE,WIN" and f[kwd.dpr_type] == "FLAT" and f[kwd.tpl_nexp] > 2 \
        and f[kwd.tpl_id] == "HAWKI_img_cal_WinSkyFlats"


def is_detnoise_flat(f):
    return is_calib_image(f) and f[kwd.dpr_type] == "FLAT" and f[kwd.det_ndit] == 1 and f[kwd.tpl_nexp] > 2 \
        and (f[kwd.tpl_id] == 'HAWKI_img_cal_TwFlats' or f[kwd.tpl_id] == 'HAWKI_img_cal_SkyFlats')


def is_off_raw(f):
    return is_calib_or_test(f) and (f[kwd.dpr_type] in ("DARK,DETCHECK", "LINEARITY,DARK,DETCHAR")) or \
        (f[kwd.dpr_type] == "BIAS,DETCHECK" and f[kwd.tpl_id] == "HAWKI_img_tec_DetLin")


def is_on_raw(f):
    return is_calib_or_test(f) and (f[kwd.dpr_type] in ("FLAT,LAMP,DETCHECK", "LINEARITY,FLAT,DETCHAR")) or \
        (f[kwd.dpr_type] == "FLAT" and f[kwd.tpl_id] == "HAWKI_img_tec_DetLin")


# ASSOCIATION RULES

def is_true(ref, f):
    return True


def is_assoc_flat_notsame(ref, f):
    return match(ref, f, [kwd.det_ncorrs_name, kwd.ins_filt1_name, kwd.ins_filt2_name, kwd.det_rspeed]) \
        and ref[kwd.mjd_obs] != f[kwd.mjd_obs]
