#ifndef ERIS_IFU_DEBUG_H
#define ERIS_IFU_DEBUG_H

/*------------------------------------------------------------------------------
 *                        Includes
 *----------------------------------------------------------------------------*/

#include <cpl.h>

//#include "eris_ifu_utils.h"

//cpl_msg_set_level(CPL_MSG_DEBUG);eris_ifu_debug_();cpl_msg_set_level(CPL_MSG_INFO);

//cpl_vector_save(vec, "vec.fits", CPL_BPP_IEEE_DOUBLE, NULL, CPL_IO_CREATE);
//cpl_image_save(img, "img.fits", CPL_BPP_IEEE_FLOAT, NULL, CPL_IO_CREATE);
//cpl_imagelist_save(cube, "cube.fits", CPL_BPP_IEEE_FLOAT, NULL, CPL_IO_CREATE);
//cpl_propertylist_save(pl, "ttt.fits", CPL_IO_CREATE);

//vec = cpl_vector_load("vec.fits", 0);
//img = cpl_image_load("img.fits", CPL_TYPE_FLOAT, 0, 0);
//cube = cpl_imagelist_load("cube.fits", CPL_TYPE_FLOAT, 0);
//pl = cpl_propertylist_load(filename, xtnum);

// pre: "set term x11;"
//      "set title 'aaa';"
// opt: "w l;" (with lines)
//      "w l t 'data1'" (t: sets label)
//      "w p lc rgbcolor \"blue\" t 'data2'"
//      "w p lc rgbcolor \"chartreuse\" t 'data3'",
//      "w p lc rgbcolor \"red\" t 'data4'"
// post:
//cpl_msg_set_level(CPL_MSG_DEBUG);
//eris_ifu_plot_vector("", "w l;", "", x);
//eris_ifu_plot_vectors_xy("", "w l;", "", x, y);
//cpl_msg_set_level(CPL_MSG_ERROR);

// eris_ifu_TRY_SET_ERROR(5);
// eris_ifu_TRY_CHECK_ERROR_STATE();

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code     eris_ifu_debug_header(const cpl_propertylist *header);

cpl_error_code     eris_ifu_debug_frameset(const cpl_frameset *frameset);

cpl_error_code     eris_ifu_debug_parameterlist(const cpl_parameterlist *p);

cpl_error_code     eris_ifu_debug_propertylist(const cpl_propertylist *plist);

cpl_error_code     eris_ifu_debug_frame(const cpl_frame *frame);

cpl_error_code     eris_ifu_debug_cube(const cpl_imagelist *imglist);

cpl_error_code     eris_ifu_debug_image(const cpl_image *img);

cpl_error_code     eris_ifu_debug_vector(const cpl_vector *vec);

cpl_error_code     eris_ifu_debug_array(const cpl_array *arr);

cpl_error_code     eris_ifu_debug_table(const cpl_table *table);

cpl_error_code     eris_ifu_plot_vector(const char *pre, const char *opt,
                                        const cpl_vector *vector);

cpl_error_code     eris_ifu_plot_vectors_xy(const char *pre, const char *opt,
                                            const cpl_vector *x,
                                            const cpl_vector *y);

cpl_error_code     eris_ifu_plot_vectors2(const char *pre, const char **opt,
                                          const cpl_vector *x,
                                          const cpl_vector *y1,
                                          const cpl_vector *y2);

cpl_error_code     eris_ifu_plot_image(const char *pre, const char *opt,
                                       const cpl_image *image);

#endif
