/* $Id$
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef ERISP_ERIS_ERIS_IFU_DISTORTION_STATIC_H_
#define ERISP_ERIS_ERIS_IFU_DISTORTION_STATIC_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include <hdrl.h>

#include "eris_ifu_functions.h"
#include "eris_ifu_vector.h"
#include "eris_ifu_constants.h"

#define NS_EST_SLIT_DIST        60
#define NS_FIT_DEGREE           3
#define ERIS_IFU_DIST_SLIT      "slit_width"
#define ERIS_IFU_DIST_YPOS      "y_pos"
#define ERIS_IFU_DIST_EDGE_L    "edge_left"
#define ERIS_IFU_DIST_EDGE_R    "edge_right"
#define ERIS_IFU_POLY_EDGE_L    "l_min"
#define ERIS_IFU_POLY_EDGE_R    "r_max"

#define ERIS_IFU_DIST_DBG_SLITLET           "slitlet"
#define ERIS_IFU_DIST_DBG_EDGE_LEFT         "edge_left"
#define ERIS_IFU_DIST_DBG_EDGE_RIGHT        "edge_right"
#define ERIS_IFU_DIST_DBG_CENTER            "x"
#define ERIS_IFU_DIST_DBG_CENTER_LEFT       "x_l"
#define ERIS_IFU_DIST_DBG_CENTER_RIGHT      "x_r"

#define ERIS_IFU_DIST_DBG_FN  "eris_ifu_distortion_dbg_dist_row_est_cen_fit_cen.fits"

struct arcstruct {
    eris_ifu_vector *fit_l;
    eris_ifu_vector *fit_c_l;
    eris_ifu_vector *fit_c;
    eris_ifu_vector *fit_c_r;
    eris_ifu_vector *fit_r;
};

cpl_vector* eris_ifu_dist_calc_centers_profile(const cpl_vector* profile,
                                               cpl_boolean lowerCutLevel);

cpl_error_code eris_ifu_dist_calc_centers_copy(const cpl_vector *fit_centers,
                                               int              y_index,
                                               double           y_value,
                                               cpl_table        **cen_array);

cpl_table **eris_ifu_dist_calc_centers(const hdrl_image *fibre_div,
                                       const hdrl_image *fibre_on,
                                       int productDepth);

cpl_vector* eris_ifu_dist_estimate_low_slitlet(const cpl_vector *est_centers);

cpl_vector* eris_ifu_dist_calc_centers_fit(const cpl_vector *profile,
                                           const cpl_vector *est_centers,
                                           cpl_boolean      do_fix_cnt);

int eris_ifu_distortion_calc_y(int n, int i);

int eris_ifu_distortion_target_left_edge(int i);

int eris_ifu_distortion_target_right_edge(int i);

int eris_ifu_distortion_get_narcs(int i, cpl_boolean triple_traces ,
                                  cpl_boolean cut_off_left,
                                  cpl_boolean cut_off_right);

cpl_polynomial** eris_ifu_dist_calc_distortion(cpl_table        **slit_edges,
                                               cpl_table        **centers,
                                               int              productDepth,
                                               cpl_boolean      cut_off_left,
                                               cpl_boolean      cut_off_right,
                                               cpl_table        **minmax_borders,
                                               cpl_propertylist ***qc,
                                               cpl_propertylist *pl,
					       cpl_frameset* frameset,
					       const cpl_parameterlist* parlist);

cpl_polynomial** eris_ifu_dist_calc_distortion_full(cpl_table   **slit_edges,
                                                    cpl_table   **centers,
                                                    int         productDepth,
                                                    cpl_boolean cut_off_left,
                                                    cpl_boolean cut_off_right);

eris_ifu_vector *eris_ifu_dist_calc_distortion_fitedge(const cpl_table *slit_edges,
                                                  const char *col_name,
                                                  const eris_ifu_vector *y_arc,
                                                  int n_calib_arc,
                                                  int n_size,
                                                  int fit_order,
                                                  int slitlet,
                                                  cpl_table *dbg_tbl);

cpl_error_code eris_ifu_dist_calc_distortion_fillgrid(cpl_bivector *grid,
                                                      const eris_ifu_vector *data,
                                                      cpl_vector *val_to_fit,
                                                      double x_pos,
                                                      int n_size,
                                                      int arc_cnt);

cpl_polynomial* eris_ifu_dist_poly_fit_2d_create(cpl_bivector      *xy_pos,
                                                 const cpl_vector  *values,
                                                 double            *msee);

cpl_error_code eris_ifu_dist_save_distortion(cpl_polynomial          **poly2d,
                                             const cpl_table         *minmax_borders,
                                             const char              *fn,
                                             cpl_frameset            *frameset,
                                             const cpl_parameterlist *parlist,
                                             cpl_propertylist        **qc);

hdrl_image *eris_ifu_dist_warp_image_full(const hdrl_image *hdrl_img_in,
                                     cpl_polynomial   **poly_u,
                                     int              productDepth);

hdrl_image* eris_ifu_dist_warp_slitlet(const hdrl_image     *imgIn,
                                       const cpl_polynomial *poly_u,
                                       const cpl_polynomial *poly_v,
                                       double                l_min,
                                       double                r_max,
                                       int                   slitletNr);

hdrl_image* eris_ifu_dist_warp_image(const hdrl_image  *imgIn,
                                     cpl_polynomial   **poly_u,
                                     const cpl_table   *borders);

hdrl_image* eris_ifu_dist_warp_bpm(const hdrl_image  *bpmIn,
                                   cpl_polynomial   **poly_u,
                                   const cpl_table   *borders,
                                   productDepthType   productDepth);

hdrl_imagelist* eris_ifu_stack_warped(const hdrl_image *imgIn,
                                             const int *rowIndices);

cpl_error_code eris_ifu_dist_warp_stats(const hdrl_image *hdrlWarpedImg,
                                        cpl_propertylist *qc_list,
                                        cpl_propertylist *pl,
										cpl_frameset* frameset,
										const cpl_parameterlist* parlist);

cpl_error_code eris_ifu_image_add_slit(hdrl_image       *imgFull,
                                       const hdrl_image *imgSlit,
                                       int              offset);

cpl_table **eris_ifu_dist_calc_slitpos(cpl_image   **arcImg,
                                       cpl_table   **centers_array,
                                       cpl_table   *valid_arc_lines,
                                       int         productDepth,
                                       cpl_boolean *cut_off_left,
                                       cpl_boolean *cut_off_right,
									   const cpl_frameset* frameset,
									   const cpl_parameterlist* parlist);

cpl_error_code eris_ifu_fit_gauss(const cpl_vector *x,
                                  const cpl_vector *y,
                                  double *x0,
                                  double *sigma,
                                  double *area,
                                  double *offset);

cpl_vector* eris_ifu_polyfit_edge(const eris_ifu_vector *x,
                                  const eris_ifu_vector *y,
                                  int   fit_order);

cpl_error_code eris_ifu_distortion_reduce_lines(cpl_table *tbl,
                                                ifsBand band,
                                                int nr_cols);

cpl_error_code eris_ifu_distortion_reduce_identical_lines(cpl_table *tbl);

cpl_table *eris_ifu_dist_wave(cpl_frameset *fs,
                              cpl_table **centers_fitted,
                              int productDepth,
                              cpl_image ***arcImgs,
                              int *arcImgCnt,
                              const cpl_parameterlist* parlist,
							  cpl_table** qclog);

cpl_error_code eris_ifu_wavecal_processSof_dist(cpl_frameset* frames,
        int exposureCorrectionMode,
        int *arcImgCnt,
        hdrl_imagelist **arcImages,
        int **lampStates,
        ifsBand *band,
        ifsPreopticsScale *scale,
        ifsInstrument *instrument,
		double saturation_threshold,
		cpl_table** qclog);

#endif /* ERISP_ERIS_ERIS_IFU_DISTORTION_STATIC_H_ */
