/* $Id: eris_dfs-test.c,v 1.6 2013-03-25 11:46:49 cgarcia Exp $
 *
 * This file is part of the ERIS Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-03-25 11:46:49 $
 * $Revision: 1.6 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/
#include <string.h>
#include <stdio.h>
#include <cpl.h>


/*----------------------------------------------------------------------------*/
/**
 * @defgroup eris_dfs_test  Unit test of eris_dfs
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/

/*----------------------------------------------------------------------------*/
/**
  @brief    Unit test of eris_dfs_set_groups
 */
/*----------------------------------------------------------------------------*/

int main(int argc, char * const argv[])
{
    /* Declarations */
    int ret =0;
    const char* file_map = NULL ;
    /* Initialize libraries */
    cpl_test_init("amodigli@eso.org", CPL_MSG_INFO);

    if(argc == 2)
    {
		file_map = argv[1];

    } else {
		fprintf(stderr, "usage: %s wave_map.fits\n", argv[0]);
		return 0;
    }
    cpl_image* wmap = cpl_image_load(file_map,CPL_TYPE_DOUBLE,0,0);
    cpl_image* res = cpl_image_duplicate(wmap);
    cpl_size sx = cpl_image_get_size_x(wmap);
    cpl_size sy = cpl_image_get_size_y(wmap);

    double* pmap = cpl_image_get_data_double(wmap);
    double* pres = cpl_image_get_data_double(res);

    cpl_size i = 0;
    cpl_size j = 0;
    for(j = 1; j < sy-1; j++){
    	for(i = 0; i < sx; i++){
    		//pres[j*sx+i] = pmap[j*sx+i]/(pmap[(j-1)*sx+i] - pmap[(j+1)*sx+i]);
    		pres[j*sx+i] = 0.5 * (pmap[(j-1)*sx+i] + pmap[(j+1)*sx+i]) /
    				             (pmap[(j-1)*sx+i] - pmap[(j+1)*sx+i]);
    		/*
    	    if( pres[j*sx+i] > 10000){
    	    	cpl_msg_info(cpl_func,"val[%lld,%lld]=%g",i,j,pres[j*sx+i]);
    	    }
    	    */
    	}
    }
    for(i = 0; i < sx; i++){
    	pres[i] = pmap[i]/(2*(pmap[i] - pmap[sx+i]));
    	//pres[(sy-1)*sx+i] = pmap[(sy-1)*sx+i]/(pmap[(sy-2)*sx+i] - pmap[(sy-1)*sx+i]);
    	pres[(sy-1)*sx+i] = 0.5*(pmap[(sy-2)*sx+i] + pmap[(sy-1)*sx+i])/
    			                (2*(pmap[(sy-2)*sx+i] - pmap[(sy-1)*sx+i]));
    	/*
   	    if( pres[j*sx+i] > 10000){
    	    	cpl_msg_info(cpl_func,"val[%lld,%lld]=%g",i,j,pres[j*sx+i]);
    	}
    	*/
    }

    cpl_msg_info(cpl_func,"resol mean %g med %g min %g max %g std %g",
    		cpl_image_get_mean(res), cpl_image_get_median(res),
			cpl_image_get_min(res), cpl_image_get_max(res),
			cpl_image_get_stdev(res));
    char file[80];
    sprintf(file,"resol_%s",file_map);
    cpl_propertylist* head = cpl_propertylist_new();
    cpl_propertylist_append_double(head,"ESO QC RESOL MEAN",cpl_image_get_mean(res));
    cpl_propertylist_append_double(head,"ESO QC RESOL MEDIAN",cpl_image_get_median(res));
    cpl_propertylist_append_double(head,"ESO QC RESOL MIN",cpl_image_get_min(res));
    cpl_propertylist_append_double(head,"ESO QC RESOL MAX",cpl_image_get_max(res));
    cpl_propertylist_append_double(head,"ESO QC RESOL STDEV",cpl_image_get_stdev(res));
    cpl_image_save(res, file, CPL_TYPE_DOUBLE, head,CPL_IO_DEFAULT);
    cpl_image_delete(wmap);
    cpl_image_delete(res);
    cpl_propertylist_delete(head);

    if (cpl_error_get_code() != CPL_ERROR_NONE) {
      cpl_msg_error(cpl_func,"error found");
      ret= 1;
    }
    cpl_test_end(0);
    return ret ;
}




/**@}*/
