/* $Id: detmon_ir_lg.c,v 1.33 2013-01-29 08:56:40 jtaylor Exp $
 *
 * This file is part of the DETMON Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: jtaylor $
 * $Date: 2013-01-29 08:56:40 $
 * $Revision: 1.33 $
 * $Name: not supported by cvs2svn $
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------
                             Includes
 ----------------------------------------------------------------------------*/

#include "detmon.h"
#include "detmon_lg.h"

#include "irplib_utils.h"

/*----------------------------------------------------------------------------
                             Defines
 ----------------------------------------------------------------------------*/

#define RECIPE_NAME "eris_nix_detmon_ir_lg"

#define NIR TRUE

/*----------------------------------------------------------------------------
				Functions prototypes
 ----------------------------------------------------------------------------*/

CPL_RECIPE_DEFINE(eris_nix_detmon_ir_lg, ERIS_BINARY_VERSION,
                     detmon_lg_fill_parlist_nir_default(recipe->parameters,
                                               "eris_nix_detmon_ir_lg", "eris"),
                     "Lander de Bilbao", PACKAGE_BUGREPORT, "2007", 
                     "Linearity/Gain recipe for the IR domain",
                     detmon_lg_get_description("eris_nix_detmon_ir_lg", "DETMON",
					       DETMON_LG_ON_RAW_NEW,
					       DETMON_LG_OFF_RAW_NEW,
					       DETMON_LG_ON_RAW_OLD,
					       DETMON_LG_OFF_RAW_OLD));
/**@{*/
/*---------------------------------------------------------------------------*/
/*
  @brief    Interpret the command line options and execute the data processing
  @param    frameset    the frames list
  @param    parlist     the parameters list
  @return   0 if everything is ok
 */
/*---------------------------------------------------------------------------*/

static int eris_nix_detmon_ir_lg(cpl_frameset            * frameset,
                        const cpl_parameterlist * parlist)
{
 

  const char * tag_on=NULL;
  const char * tag_off=NULL;
   cpl_propertylist * lintbl = 
	detmon_fill_prolist("DET_LIN_INFO", "REDUCED", "TECH", CPL_FALSE);

    cpl_propertylist * gaintbl = 
	detmon_fill_prolist("GAIN_INFO",    "REDUCED", "TECH", CPL_FALSE);

    cpl_propertylist * coeffscube = 
	detmon_fill_prolist("COEFFS_CUBE",  "REDUCED", "TECH", CPL_FALSE);

    cpl_propertylist * bpm = 
	detmon_fill_prolist("BP_MAP_NL",    "REDUCED", "TECH", CPL_FALSE);

    cpl_propertylist * corr = 
	detmon_fill_prolist("AUTOCORR",     "REDUCED", "TECH", CPL_FALSE);

    cpl_propertylist * diff_flat = 
	detmon_fill_prolist("DIFF_FLAT",    "REDUCED", "TECH", CPL_FALSE);

    cpl_error_code error=CPL_ERROR_NONE;
    skip_if (detmon_lg_set_tag(frameset, &tag_on, &tag_off));
 
    error = detmon_lg(frameset,
		      parlist,
		      tag_on,
		      tag_off,
		      RECIPE_NAME,
		      PACKAGE_TARNAME,
		      REGEXP,
		      lintbl, gaintbl, coeffscube,
		      bpm, corr, diff_flat,
		      PACKAGE "/" PACKAGE_VERSION,
		      NULL, NULL, NIR);
    end_skip;
    cpl_propertylist_delete(lintbl);
    cpl_propertylist_delete(gaintbl);
    cpl_propertylist_delete(coeffscube);
    cpl_propertylist_delete(bpm);
    cpl_propertylist_delete(corr);
    cpl_propertylist_delete(diff_flat);

    /* Propagate the error, if any */
    cpl_ensure_code(!error, error);

    return cpl_error_get_code();
}
/**@}*/
