# AREA A1: the import statements
# import statements needed by esoreflex
import reflex
import sys
from optparse import OptionParser
import json
import os
import time

# Import statements needed by the 
# algorithm to execute
from astropy.io import fits as fits
import numpy as np

# END OF AREA A1

# AREA A2: the algorithm(s).
# This is the function that is called by the python script.  The
# function reads the input, edits it. It divides a box region in the
# data by 2 and save the changes into a new file.


# END OF AREA A2

# AREA A3: the interface.
# This is the main Phython script. It contains 2 general parts and a
# customized part, that is responsible of calling the desired
# reduction function.

if __name__ == '__main__':

    # ***  PART P1: Input/output ports *** 
    # Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("-i", "--in_sof", dest="in_sof")
    parser.add_output("-o", "--out_single", dest="out_single")
    # parser.add_input("-k", "--extra_input_port", dest="extra_input_port")
    parser.add_output("-q", "--out_cube", dest="out_cube")
    inputs = parser.get_inputs()
    outputs = parser.get_outputs()
    in_sof = inputs.in_sof
    files = in_sof.files
    # in_sof2 = inputs.extra_input_port
    # files2 = in_sof2.files

    # Define the list of outputs
    output_files = list()
    output_datasetname = in_sof.datasetName

    # Get the name of the output directory
    pattern = '--products-dir'
    for arg in sys.argv:
        if arg.split("=")[0] == pattern:
            output_dir = arg.split("=")[1]

    # ***  END OF PART P1 ***

    # ***  PART P2: customized part***

    # THE SCRIPT DOES A LOOP ON THE INPUT FILES AND PROCESS ONLY SPECIFIED CATEGORIES
    # INDIVIDUALLY 
    file_to_inspect = 'tbd'
    check_format = False
    for file in files:
        if file.category in ['CAL_DET_OBJECT_JITTER', 'OBJECT_JITTER']:
            file_to_inspect = file.name
            check_format = True
        elif file.category in ['CAL_DET_STD_JITTER', 'STD_JITTER']:
            file_to_inspect = file.name
            check_format = True
        elif file.category in ['CAL_DET_OBJECT_LSS_JITTER', 'OBJECT_LSS_JITTER']:
            file_to_inspect = file.name
            check_format = True
        elif file.category in ['CAL_DET_STD_LSS_JITTER', 'STD_LSS_JITTER']:
            file_to_inspect = file.name
            check_format = True

    if file_to_inspect != 'tbd':
        hdu = fits.open(file_to_inspect)
        val = hdu[0].header['HIERARCH ESO DET FRAM FORMAT']
    else:
        val = 'cube'
    # *** END OF PART P2***

    # *** PART P3: broadcast products ***

    # After the script is completed, the list of products is
    # broadcasted to the output sof.
    empty_sof = json.dumps({"datasetName": '', "files": [], "class": "org.eso.domain.SetOfFiles"})

    if val == 'cube':
        outputs.out_cube = in_sof
        outputs.out_single = empty_sof
    else:
        outputs.out_single = in_sof
        outputs.out_cube = empty_sof

    #  Broadcast outputs on the extra output port, if needed
    # outputs.extra_output_port = new_sof

    # broadcast outputs:
    parser.write_outputs()
    sys.exit()
    # ***  END OF PART P2 ***
    # ***  END OF AREA A3***
