from adari_core.data_libs.master_dark_bias import MasterRawCutsReport
from adari_core.plots.images import ImagePlot
from adari_core.plots.panel import Panel
from adari_core.plots.text import TextPlot
from .eris_utils import ErisSetupInfo
from .eris_utils import ErisReportMixin

import os


class ErisMasterDarkReport(ErisReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("eris_master_dark")
        self.ifu = False

    def parse_sof(self):
        master_dark = None
        bpm_dark = None
        for filename, catg in self.inputs:
            if catg == "MASTER_DARK_IMG" or catg == "MASTER_DARK_IFU":
                master_dark = filename
            elif catg == "BPM_DARK":
                bpm_dark = filename
                self.ifu = True
        file_lists = []
        if master_dark is not None:
            if bpm_dark is not None:
                file_lists.append(
                    {
                        "master_im": master_dark,
                        "bpm": bpm_dark,
                    }
                )
            else:
                file_lists.append(
                    {
                        "master_im": master_dark,
                    }
                )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3
        ext = "DATA"
        new_panels = super().generate_panels(
            master_im_ext=ext,
        )
        extra_panels = {}

        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            panel_descr["report_description"] = (
                f"ERIS dark panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{panel_descr['master_im_ext']}"
            )

            master_im = self.hdus[i]["master_im"]

            # Text Plot
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)

            col1 = (
                str(master_im["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + ext,
                "PRO CATG: "
                + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    master_im["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")
                ),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            if self.ifu:
                self.metadata = ErisSetupInfo.ifu_dark(master_im)
            else:
                self.metadata = ErisSetupInfo.nix_dark(master_im)
            col2 = self.metadata
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

            # Four panel plot with data, err, dq, bpm

            pextra = Panel(2, 3, height_ratios=[1, 4, 4])
            pextra.assign_plot(t1, 0, 0, xext=1)
            pextra.assign_plot(t2, 1, 0, xext=1)

            if self.ifu:
                plot_data = ImagePlot(
                    master_im[1].data,
                    title="DATA",
                    v_clip="percentile",
                    v_clip_kwargs={"percentile": 50.0},
                )
                pextra.assign_plot(plot_data, 0, 1)
                plot_data = ImagePlot(
                    master_im[2].data,
                    title="ERR",
                    v_clip="percentile",
                    v_clip_kwargs={"percentile": 50.0},
                )
                pextra.assign_plot(plot_data, 1, 1)
                plot_data = ImagePlot(
                    master_im[3].data,
                    title="DQI",
                    v_clip="val",
                    v_clip_kwargs={"low": 0, "high": 64},
                    interpolation="none",
                )
                pextra.assign_plot(plot_data, 0, 2)
                bpm = self.hdus[i]["bpm"]
                plot_data = ImagePlot(
                    bpm[0].data,
                    title="BPM",
                    v_clip="val",
                    v_clip_kwargs={"low": 0, "high": 1},
                    interpolation="none",
                )
                pextra.assign_plot(plot_data, 1, 2)
            else:
                plot_data = ImagePlot(
                    master_im[1].data,
                    title="DATA",
                    v_clip="percentile",
                    v_clip_kwargs={"percentile": 95.0},
                )
                pextra.assign_plot(plot_data, 0, 1)
                plot_data = ImagePlot(
                    master_im[2].data,
                    title="ERR",
                    v_clip="percentile",
                    v_clip_kwargs={"percentile": 50.0},
                )
                pextra.assign_plot(plot_data, 1, 1)
                plot_data = ImagePlot(
                    master_im[3].data,
                    title="DQ",
                    v_clip="val",
                    v_clip_kwargs={"low": 0, "high": 1},
                    interpolation="none",
                )
                pextra.assign_plot(plot_data, 0, 2)
                plot_data = ImagePlot(
                    master_im[4].data,
                    title="HOT_BPM",
                    v_clip="val",
                    v_clip_kwargs={"low": 0, "high": 1},
                    interpolation="none",
                )
                pextra.assign_plot(plot_data, 1, 2)
            addme = {}
            addme["report_name"] = panel_descr["report_name"] + "_extra"
            addme["report_description"] = (
                f"ERIS dark additional panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{panel_descr['master_im_ext']}"
            )
            addme["report_tags"] = []
            extra_panels[pextra] = addme

        panels = {**new_panels, **extra_panels}

        return panels


rep = ErisMasterDarkReport()
