from .espresso_rawdisp import EspressoSetupInfo
from adari_core.data_libs.master_detmon import MasterDetmonReport
from adari_core.plots.text import TextPlot


class EspressoDetmonReport(MasterDetmonReport):
    files_needed = {
        "on": "DETMON_LAMP_ON",
        "off": "DETMON_LAMP_OFF",
        "gain_info": "GAIN_INFO",
        "detlin_info": "DET_LIN_INFO",
        "coeffs_cube": "COEFFS_CUBE",
    }
    center_size = 200

    def __init__(self):
        super().__init__("espresso_detmon", self.files_needed)

    def access_port(self, im_hdu, port):
        return im_hdu

    def generate_panels(self, **kwargs):
        panels = {}

        data_info = {}
        data_info["exptime_key"] = "EXPTIME"
        data_info["gain_nominal_key"] = "HIERARCH ESO DET OUT1 CONAD"
        data_info["lintime_key"] = "EXPTIME"
        data_info["gain_qc_key"] = "HIERARCH ESO QC GAIN AVG"
        data_info["lin_qc_key"] = "HIERARCH ESO QC REG1 LIN"

        exts = ["CCD290red", "CCD290blue"]

        for ext in exts:
            new_panels = super().generate_panels(
                data_info=data_info,
                ext=ext,
                port=1,
            )

            for panel, panel_descr in new_panels.items():
                # Metadata
                metadata = EspressoSetupInfo.detmon(list(self.hdus[0].values())[0])
                text2 = TextPlot(v_space=self.METADATA_V_SPACING)
                text2.add_data(metadata)
                panel.assign_plot(text2, 1, 0)

            panels = {**panels, **new_panels}

        return panels


rep = EspressoDetmonReport()
