from adari_core.utils.esodet import strip_prescan_overscan_espresso
from adari_core.data_libs.master_wave_espresso import MasterWaveReport

from .espresso_utils import EspressoReportMixin


class EspressoWavelengthCalibReport(EspressoReportMixin, MasterWaveReport):
    def __init__(self):
        super().__init__("espresso_wavecalib")

    def remove_raw_scan(self, im_hdu, **kwargs):
        return strip_prescan_overscan_espresso(im_hdu, **kwargs)

    def parse_sof(self):
        # building one report set

        line_table_a_catgs = [
            "FP_FITTED_LINE_TABLE_THAR_FP_A",
            "FP_FITTED_LINE_TABLE_FP_THAR_A",
        ]
        line_table_b_catgs = [
            "FP_FITTED_LINE_TABLE_THAR_FP_B",
            "FP_FITTED_LINE_TABLE_FP_THAR_B",
        ]
        res_table_a_catgs = ["THAR_LINE_TABLE_THAR_FP_A", "THAR_LINE_TABLE_FP_THAR_A"]
        res_table_b_catgs = ["THAR_LINE_TABLE_THAR_FP_B", "THAR_LINE_TABLE_FP_THAR_B"]
        raw_catgs = [
            "WAVE",
            "FP_FP",
            "FP_LFC",
            "LFC_FP",
            "WAVE_FP",
            "THAR_FP",
            "FP_THAR",
        ]

        addme = {}
        for filename, catg in self.inputs:
            if catg in line_table_a_catgs:
                addme["line_table_a"] = filename
            if catg in line_table_b_catgs:
                addme["line_table_b"] = filename

            if catg in res_table_a_catgs:
                addme["res_table_a"] = filename
            if catg in res_table_b_catgs:
                addme["res_table_b"] = filename

            if catg in raw_catgs:
                addme["raw"] = filename
        # Build and return the (one) file name list
        file_lists = []
        file_lists.append(addme)
        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        exts = ["CCD290red", "CCD290blue"]

        for ext in exts:
            new_panels = super().generate_panels(ext=ext)
            for panel_descr in new_panels.values():
                panel_descr["report_description"] = (
                    f"ESPRESSO wavelength calibration panel - {panel_descr['ext']}"
                )
            panels = {**panels, **new_panels}
        return panels


rep = EspressoWavelengthCalibReport()
