/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_MODEL_PSF_H
#define QMOST_MODEL_PSF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*----------------------------------------------------------------------------*/
/*
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/*
 *                              Function prototypes
 */
/*----------------------------------------------------------------------------*/

cpl_error_code qmost_model_psf_full (
    cpl_image *in_img,
    cpl_propertylist *in_hdr,
    cpl_table *trace_tbl,
    cpl_propertylist *trace_hdr,
    int profwidth,
    int subsample,
    int sblock,
    cpl_imagelist **prof_img,
    cpl_imagelist **prof_var,
    cpl_propertylist *prof_hdr);

cpl_error_code qmost_psf_stats (
    cpl_imagelist *prof_img,
    cpl_propertylist *prof_hdr,
    int arm,
    int startpoint,
    cpl_table *fibinfo_tbl);

CPL_END_DECLS

#endif  /* QMOST_MODEL_PSF_H */
