/*
 * This file is part of the QMOST Pipeline
 * Copyright (C) 2002-2022 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef QMOST_PFITS_H
#define QMOST_PFITS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

CPL_BEGIN_DECLS

/*-----------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/

/**
 * @ingroup qmost_pfits
 *
 * EXTNAME of the FIBINFO table.
 */

#ifndef QMOST_FIBINFO_EXTNAME
#ifdef OPR2
#define QMOST_FIBINFO_EXTNAME "FIBRE_CONFIG"
#else
#define QMOST_FIBINFO_EXTNAME "FIBINFO"
#endif  /* OPR3 */
#endif  /* QMOST_FIBINFO_EXTNAME */

/**
 * @ingroup qmost_pfits
 *
 * EXTNAME of the METROLOGY table.
 */
#ifndef QMOST_METROLOGY_EXTNAME
#define QMOST_METROLOGY_EXTNAME "METROLOGY"
#endif  /* QMOST_METROLOGY_EXTNAME */

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code qmost_pfits_get_arm (
    cpl_propertylist *plist,
    int *arm);

cpl_error_code qmost_pfits_get_detlive (
    cpl_propertylist *plist,
    int *detlive);

cpl_error_code qmost_pfits_get_dummy (
    cpl_propertylist *plist,
    int *dummy);

cpl_error_code qmost_pfits_get_exptime (
    cpl_propertylist *plist,
    double *exptime);

const char *qmost_pfits_get_extname (
    int arm);

cpl_error_code qmost_pfits_get_minyst (
    cpl_propertylist *plist,
    int *result);

cpl_error_code qmost_pfits_get_maxyfn (
    cpl_propertylist *plist,
    int *result);

cpl_error_code qmost_pfits_get_mjd_obs (
    cpl_propertylist *plist,
    double *mjd);

cpl_error_code qmost_pfits_get_spectrograph (
    cpl_propertylist *plist,
    int *fib_root);

CPL_END_DECLS

#endif
