dnl @synopsis SPLIT_VERSION
dnl
dnl Splits a version number in the format MAJOR.MINOR.POINT into it's
dnl separeate components.
dnl 
dnl Sets the variables.
dnl

AC_DEFUN([AB_SPLIT_VERSION],[
    ac_major_version=`echo "$VERSION" | $SED 's/\([[^.]][[^.]]*\).*/\1/'`
    ac_minor_version=`echo "$VERSION" | $SED 's/[[^.]][[^.]]*.\([[^.]][[^.]]*\).*/\1/'`
    ac_point_version=`echo "$VERSION" | $SED 's/[[^.]][[^.]]*.[[^.]][[^.]]*.\(.*\)/\1/'`

    AC_SUBST(MAJOR_VERSION, $ac_major_version)
    AC_SUBST(MINOR_VERSION, $ac_minor_version)
    AC_SUBST(POINT_VERSION, $ac_point_version)
    AC_SUBST(LIBRARY_VERSION, `expr $MAJOR_VERSION + $MINOR_VERSION`:`expr $POINT_VERSION + 0`:`expr $MINOR_VERSION + 0`)

    AC_MSG_CHECKING([Major version])
    AC_MSG_RESULT([$MAJOR_VERSION])
    AC_MSG_CHECKING([Minor version])
    AC_MSG_RESULT([$MINOR_VERSION])
    AC_MSG_CHECKING([Point version])
    AC_MSG_RESULT([$POINT_VERSION])
    AC_MSG_CHECKING([Library version])
    AC_MSG_RESULT([$LIBRARY_VERSION])
])
