pav:
	subdirlist='$(SUBDIRS)'; for subdir in $$subdirlist; do \
          echo "Visiting $$subdir"; \
          $(MAKE) -C $$subdir pav \
          || eval $$failcom; \
        done; 
	$(MAKE) $(check_PROGRAMS)



stamp-version:
	cd $(srcdir); \
	$(top_srcdir)/config/sand.sh -v -s '@version .*$$' -r "@version $(PACKAGE_VERSION)" $(HEADERS)
	subdirlist='$(SUBDIRS)'; for subdir in $$subdirlist; do \
          echo "Visiting $$subdir"; \
          (cd $$subdir && $(MAKE) stamp-time) \
          || eval $$failcom; \
        done; 

stamp-time:
	cd $(srcdir); \
	$(top_srcdir)/config/sand.sh -v -s '@date .*$$' -r "@date `date '+%F %X'`" $(HEADERS)
	subdirlist='$(SUBDIRS)'; for subdir in $$subdirlist; do \
          echo "Visiting $$subdir"; \
          (cd $$subdir && $(MAKE) stamp-version) \
          || eval $$failcom; \
        done; 

stamp: stamp-time stamp-version

svn-add:
	cd $(srcdir); \
        for i in $(HEADERS) $(srcdir)/Makefile.am $(DIST_SOURCES) $(TEXINFOS) $(EXTRA_DIST) $(SUBDIRS); do \
          if ! svn list $$i 2> /dev/null; then \
             svn -N add $$i;  \
          else \
             echo already added $$i; \
          fi; \
        done;
	subdirlist='$(SUBDIRS)'; for subdir in $$subdirlist; do \
          echo "Visiting $$subdir"; \
          (cd $$subdir && $(MAKE) svn-add) \
          || eval $$failcom; \
        done; 



svn-dist: svn-add
	cd $(srcdir); 

svn-commit:
	svn ci

svn-ci:
	svn ci -m ""


configure.in.in:
	grep -v -e 'AC_CONFIG_FILES\|AC_OUTPUT'  configure.in > $(top_builddir)/configure.in.in

configure.in-rebuild: 
	echo $(subdir) $(SUBDIRS);
	subdirlist='$(SUBDIRS)'; for i in $$subdirlist; do \
           echo AC_CONFIG_FILES\($(subdir)/$$i/Makefile\) >> $(top_builddir)/configure.in.in;\
          (cd $$i && $(MAKE) configure.in-rebuild) || eval $$failcom; \
        done; 

nice-subdirs: configure.in.in
	cd $(top_srcdir); 
	echo AC_OUTPUT >> $(top_builddir)/configure.in.in;
	$(MAKE) configure.in-rebuild



deps:
	for i in $(patsubst %,$(DEPDIR)/%.Po, $(basename $(SOURCES))); do \
           test -z $$i || :> $$i; \
        done;

RPM_ROOTDIR             = /usr/src/packages/
RPM_SRCDIR              = $(RPM_ROOTDIR)/SOURCES
RPM_SPECDIR             = $(RPM_ROOTDIR)/SPECS
RPM_ARCH                = i586
RPM_RPMDIR              = $(RPM_ROOTDIR)/RPMS/$(RPM_ARCH)

RPM_INSTALLROOT         = /instroot

rpm-spec:
	sed -e "s,@NAME@,${PACKAGE_TARNAME}," \
            -e "s,@VER@,${PACKAGE_VERSION}," \
            -e "s,@REL@,${PACKAGE_RELEASE}," \
            -e "s,@USER@,$$USERNAME," \
            -e "s,@EMAIL@,$$USEREMAIL," \
            -e "s,@PREFIX@,$(RPM_INSTALLROOT)," \
            $(top_srcdir)/config/template.spec.in > $(top_builddir)/config/${PACKAGE_NAME}.spec

rpm: stamp distcheck rpm-spec
	cp -f $(top_builddir)/$(PACKAGE_TARNAME)-$(VERSION).tar.bz2 $(RPM_SRCDIR)
	cp -f $(top_builddir)/config/$(PACKAGE).spec $(RPM_SPECDIR)
	rpmbuild -ba --clean $(RPM_SPECDIR)/$(PACKAGE).spec


	
