#!/bin/bash
# Skript:       sand.sh
# Zweck:        search and replace

# Globale Variablen
SCRIPTNAME=$(basename $0 .sh)

EXIT_SUCCESS=0
EXIT_FAILURE=1
EXIT_ERROR=2
EXIT_BUG=10

# Variablen für Optionsschalter hier mit Default-Werten vorbelegen
VERBOSE=n
OPTFILE=""

# Funktionen
function usage {
        echo "Usage: $SCRIPTNAME [-h] [-v] -s search -r replace file[s] ..." >&2
        [[ $# -eq 1 ]] && exit $1 || exit $EXIT_FAILURE
}

# Die Option -h für Hilfe sollte immer vorhanden sein, die Optionen
# -v und -o sind als Beispiele gedacht. -o hat ein Optionsargument;
# man beachte das auf "o" folgende ":".
while getopts ':s:r:vh' OPTION ; do
        case $OPTION in
        v)        VERBOSE=y
                ;;
        s)        SEDSEARCH="$OPTARG"
                ;;
        r)        SEDREPLACE="$OPTARG"
                ;;
        h)        usage $EXIT_SUCCESS
                ;;
        \?)        echo "Unknown Option \"-$OPTARG\"." >&2
                usage $EXIT_ERROR
                ;;
        :)        echo "Option \"-$OPTARG\" needs an argument." >&2
                usage $EXIT_ERROR
                ;;
        *)        echo "This shouldnt happen..."
>&2
                usage $EXIT_BUG
                ;;
        esac
done
# Skip used arguments
shift $(( OPTIND - 1 ))

# Eventuelle Tests auf min./max. Anzahl Argumente hier
if (( $# < 1 )) ; then
        echo "Noting todo." >&2
        exit
fi

# Loop through the rest
for ARG ; do
        if ! test -d $ARG; then 
           mv $ARG $ARG.orig;
           sed "s,$SEDSEARCH,$SEDREPLACE,g" $ARG.orig > $ARG;
           if [[ $VERBOSE = y ]] ; then
                echo "searching... " $ARG 
           fi
        else
           echo skipping directory $ARG
        fi;
done

exit $EXIT_SUCCESS

