/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IFS_SCIENCE_H_
#define SPH_IFS_SCIENCE_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include "sph_framecombination.h"
#include "sph_master_frame.h"
#include "sph_pixel_description_table.h"
#include "sph_ifs_lenslet_model.h"
#include "sph_ldt.h"
#include "sph_raw_image_corrector_data.h"

#include <cpl.h>


/*-----------------------------------------------------------------------------
 Defines
 -----------------------------------------------------------------------------*/

#define SPH_TEMP_KEYWORD_USE_ILLUM_PATTERN "TEMP_KEYWORD_USE_ILLUM"

/*-----------------------------------------------------------------------------
 Declarations
 -----------------------------------------------------------------------------*/

extern const char* const SPH_IFS_STAR_CENTER_TIME_UT_NAME;
extern const char* const SPH_IFS_STAR_CENTER_CENTX_NAME;
extern const char* const SPH_IFS_STAR_CENTER_CENTY_NAME;
extern const char* const SPH_IFS_STAR_CENTER_DMS_POS_X_NAME;
extern const char* const SPH_IFS_STAR_CENTER_DMS_POS_Y_NAME;

cpl_frameset*
sph_ifs_science_create_super_flats(cpl_frameset* science_rawframeset,
        cpl_frame* ldff1_frame, cpl_frame* ldff2_frame, cpl_frame* ldff3_frame,
        cpl_frame* ldff4_frame, cpl_frame* ldffbb_frame,
        cpl_frame* sdffbb_frame, cpl_frameset* pdtframeset) CPL_ATTR_ALLOC;

sph_ldt*
sph_ifs_science_create_wavelength_cube(cpl_image* rawimage,
        sph_master_frame* dark, cpl_mask* bpixmask,
        sph_master_frame* preamp_flat, sph_master_frame* sdffbb,
        cpl_frame* super_flat_frame, sph_pixel_description_table* pdt,
        sph_ifs_lenslet_model* lensmodel, cpl_table* ifu_flat,
        cpl_propertylist* props, int use_illum) CPL_ATTR_ALLOC;
sph_ldt*
sph_ifs_science_reduce_dither_no_adi(cpl_frameset* science_rawframeset,
        sph_collapse_algorithm colalg, sph_ifs_lenslet_model* lensmodel,
        cpl_frame* dark_frame, cpl_frame* static_bpix_frame,
        cpl_frame* wavecal_frame, cpl_frame* preamp_corr_frame,
        cpl_frame* ifu_flat_frame, cpl_frame* ldff1_frame,
        cpl_frame* ldff2_frame, cpl_frame* ldff3_frame, cpl_frame* ldff4_frame,
        cpl_frame* ldffbb_frame, cpl_frame* sdffbb_frame) CPL_ATTR_ALLOC;
cpl_frameset*
sph_ifs_science_collapse_ldts(const cpl_frameset* ldtframes,
                              cpl_frameset* inframes,
                              const cpl_frame* lenslet_distortion_frame,
                              const char* recipe,
                              const char* tag) CPL_ATTR_ALLOC;

cpl_frameset*
sph_ifs_science_reduce_cubes(cpl_frameset* science_rawframeset,
        cpl_frameset* inframes, cpl_parameterlist* inparams,
        sph_ifs_lenslet_model* lensmodel, const cpl_frame* dark_frame,
        const cpl_frame* static_bpix_frame, const cpl_frame* wavecal_frame,
        const cpl_frame* preamp_corr_frame, const cpl_frame* ifu_flat_frame,
        const cpl_frame* lenslet_distortion_map, cpl_frame* ldff1_frame,
        cpl_frame* ldff2_frame, cpl_frame* ldff3_frame, cpl_frame* ldff4_frame,
        cpl_frame* ldffbb_frame, cpl_frame* sdffbb_frame, const char* recipe,
        const char* tag, int use_illum,
		sph_raw_image_corrector_data* corrector_data) CPL_ATTR_ALLOC;
sph_ldt*
sph_ifs_science_reduce_no_dither_no_adi(cpl_frameset* science_rawframeset,
        sph_collapse_algorithm colalg, sph_ifs_lenslet_model* lensmodel,
        cpl_frame* dark_frame, cpl_frame* static_bpix_frame,
        cpl_frame* wavecal_frame, cpl_frame* preamp_corr_frame,
        cpl_frame* ifu_flat_frame, cpl_frame* ldff1_frame,
        cpl_frame* ldff2_frame, cpl_frame* ldff3_frame, cpl_frame* ldff4_frame,
        cpl_frame* ldffbb_frame, cpl_frame* sdffbb_frame) CPL_ATTR_ALLOC;
sph_master_frame*
sph_ifs_science_reduce_and_collapse(cpl_frameset* science_rawframeset,
        cpl_frameset* inframes, cpl_parameterlist* inparams,
        sph_collapse_algorithm colalg, sph_ifs_lenslet_model* lensmodel,
        const cpl_frame* dark_frame, cpl_frame* static_bpix_frame,
        cpl_frame* wavecal_frame, cpl_frame* preamp_frame,
        cpl_frame* ifu_flat_frame, cpl_frame* lenslet_distortion_frame,
        cpl_frame* ldff1_frame, cpl_frame* ldff2_frame, cpl_frame* ldff3_frame,
        cpl_frame* ldff4_frame, cpl_frame* ldffbb_frame,
        cpl_frame* sdffbb_frame, const char* recipename, const char* tag)
    CPL_ATTR_ALLOC;

sph_ldt*
sph_ifs_science_combine_ldts(cpl_frameset* ldtframes,
        sph_collapse_algorithm coll_alg) CPL_ATTR_ALLOC;

#endif /* SPH_IFS_SCIENCE_H_ */
