/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ifs_spectra_positions.h"
#include "sph_common_keywords.h"
#include "sph_ifs_keywords.h"
#include "sph_ifs_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IFS_SPECTRA_POSITIONS_GENERAL              = SPH_IFS_SPECTRA_POSITIONS_ERR_START + 0;
sph_error_code SPH_IFS_SPECTRA_POSITIONS_NO_VALID_DIT_LIST    = SPH_IFS_SPECTRA_POSITIONS_ERR_START + 1;

sph_error_code SPH_IFS_SPECTRA_POSITIONS_PARAMETER_MISSING    = SPH_IFS_SPECTRA_POSITIONS_ERR_START + 3;
sph_error_code SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING       = SPH_IFS_SPECTRA_POSITIONS_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ifs_spectra_positions_create_plugin ( cpl_plugin * );
static int sph_ifs_spectra_positions_exec_plugin ( cpl_plugin * );
static int sph_ifs_spectra_positions_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ifs_spectra_positions_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IFS_SPECPOS_RAW                 1, -1   The input raw frames. These should be taken in the zero reference dithering position\n"
    "                                        and contain bright (almost saturated) images of the spectra regions from the lenslet\n"
    "                                        array.    \n"
    "IFS_INSTRUMENT_FLAT_FIELD       0,  1   The master flat field to use. This can either be a master detector flat field\n"
    "                                        or an instrument flat field (but not an IFU flat field).\n"
    "IFS_CAL_BACKGROUND              0,  1   An optional master background frame for dark subtraction.\n"
    "IFS_MASTER_DARK                 0,  1   An optional master dark frame for dark subtraction.\n"
    "                                        This should have the same DIT and readout mode as the\n"
    "                                        input raw frames\n"
    "IFS_LENSLET_MODEL               0,  1   An optional frame containing in the header the IFS lenslet model parameters. If none\n"
    "                                        is provided the default model parameters are used.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe associates the IFS spectra with lenslets and associates pixels with wavelengths. \n"
    "The wavelengths are an initial estimation from the lenslet model and the sph_ifs_wave_calib should be used to refine \n"
    "them.\n"
    "\n"
    "The raw frames are reduced by optionally dark subtracting either a master\n"
    "background or a master dark and by flat fielding and then combined using the\n"
    "combination algorithm chosen (usually the clean mean algorithm). The flat field used can be either\n"
    "a detector flat field, a flat field of the whole instrument (detector+IFU) or any other flat\n"
    "deemed to be useful for this purpose. In most cases a detector flat field obtained with the\n"
    "broad band calibration lamp seems the best choice.\n"
    "After a combined and reduced frame has been produced the following\n"
    "algorithm is applied:\n"
    "\n"
    "-   A thresholding algorithm will determine the spectra regions from the\n"
    "    combined frame. From the\n"
    "\n"
    "    regions a point pattern is calculated. A point pattern is a list of\n"
    "    points. In this case the points\n"
    "\n"
    "    are the centers of the regions;\n"
    "\n"
    "-   Calculate the average width of the spectra regions and use it to\n"
    "    scale the width and the stretch factors (x and y directions) of the\n"
    "    IFS lenslet model;\n"
    "\n"
    "-   A second point pattern is then determined using the (scaled) IFS\n"
    "    lenslet model. If a IFS lenslet model was provided in the form of a\n"
    "    FITS file with the model parameters as\n"
    "\n"
    "    keywords in its header, this model is used, otherwise the default\n"
    "    model is used, please see the description of the lenslet model in\n"
    "    the section on static calibrations;\n"
    "\n"
    "-   The expected point pattern is compared with the actual one to\n"
    "    determine a relative scale and an offset;\n"
    "\n"
    "-   The IFS lenslet model used for the expected pattern is subsequently\n"
    "    scaled and shifted accordingly to reflect the new, actual values of\n"
    "    scale and position.\n"
    "\n"
    "-   If desired, the distortion is calculated. This may be crucial to\n"
    "    ensure correct wavelength\n"
    "\n"
    "    calibrations later in the calibration cascade. If distortion is\n"
    "    allowed (using the ifs.spectra_positions.distortion parameter)\n"
    "\n"
    "    then the recipe will also fit a 2D polynomial of 4th order in x and\n"
    "    y directions to the difference between\n"
    "\n"
    "    measured and predicted point patterns. The coefficients of this\n"
    "    polynomial model are incorporated in the IFS_SPECPOS product and\n"
    "    will be used subsequently in all recipes making use of the created\n"
    "    lenslet model file.\n"
    "\n"
    "-   For each pixel having coordinates $(x, y)$ an initial wavelength\n"
    "    estimation is calculated. For each point the polygon it belongs to\n"
    "    is calculated according to the refined model. The polygon can be\n"
    "    rotated, therefore a new aligned polygon having the same center,\n"
    "    width and height is calculated. The lower $y$ coordinate $y_{low}$\n"
    "    of the aligned polygon is used to calculate the corresponding\n"
    "    wavelength $lambda(y)$:\n"
    "\n"
    "    $$lambda(y) = (y - 0.5 - y_{low})*d + lambda_{min}$$\n"
    "\n"
    "    where $d$ is the model dispersion and $lambda_{min}$ is the minimum\n"
    "    wavelength according to the model;\n"
    "\n"
    "-   A non linear correction is then applied to $lambda(y)$ if\n"
    "    ifs.spectra_positions.correct_nonlin = TRUE:\n"
    "\n"
    "    $$lambda'(y) = a*lambda^2(y) +  (b + 1)*lambda(y) + c$$\n"
    "\n"
    "    where $a$, $b$ and $c$ are 0.30870, -0.74312, 0.41505 in H mode and\n"
    "    0.67754, -1.4464, 0.75754 in Y mode respectively;\n"
    "\n"
    "\n"
    "\n"
    "Finally the calculated data (mode, wavelengths, distortion) is used to construct a pixel description\n"
    "table which is saved, together with the corrected lenslet model parameters, as the primary\n"
    "product of this recipe.\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IFS_SPECPOS                        FITS[Im(6)]    The resulting pixel description table (PDT) written out as images. The PDT is written as a\n"
    "                                        FITS file with 6 extensions, corresponding to: wavelength, spectra region id, lenslet id, wavelength width,\n"
    "                                        second derivate of wavelength and illumination fraction. Currently the last two extensions are not\n"
    "                                        used in any recipe. \n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ifs_spectra_positions Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ifs_spectra_positions.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IFS_SPECTRA_POSITIONS_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ifs_spectra_positions",
                        "Determinate of the spectra regions on detector",
                        sph_ifs_spectra_positions_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ifs_spectra_positions_create_plugin,
                        sph_ifs_spectra_positions_exec_plugin,
                        sph_ifs_spectra_positions_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_spectra_positions_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ifs_spectra_positions_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IFS_SPECTRA_POSITIONS_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ifs_spectra_positions_create_test(cpl_plugin * plugin)
{
    return (int)sph_ifs_spectra_positions_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_spectra_positions_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ifs_spectra_positions*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ifs_spectra_positions_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ifs_spectra_positions_run( sph_recipe );

        sph_ifs_spectra_positions_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_spectra_positions_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ifs_spectra_positions struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ifs_spectra_positions_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ifs.spectra_positions.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ifs.spectra_positions",
                                   "spectra_positions.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ifs.spectra_positions.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean. "
                                   "A clean mean should be chosen to avoid contamination by cosmic rays. "
                                   ,"ifs.spectra_positions",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.spectra_positions.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. "
                                   "Choose a value above 0 to remove contamination by cosmics. "
                                   ,"ifs.spectra_positions",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.spectra_positions.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. "
                                   ,"ifs.spectra_positions",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.threshold",
                                   CPL_TYPE_DOUBLE,
                                   "The threshold for detection of spectra regions (counts) "
                                   "If this is set to a negative value, the thresholding level is calculated automatically as "
                                   "the sum of the median value of the combined raw frames and the standard deviation on the "
                                   "combined raw frame. "
                                   ,"ifs.spectra_positions",
                                   -1.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.minpix",
                                   CPL_TYPE_INT,
                                   "The minimum number of pixels a connected region has to contain to qualify as a spectra "
                                   "region. "
                                   ,"ifs.spectra_positions",
                                   25 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.angle",
                                   CPL_TYPE_DOUBLE,
                                   "The rotation angle to assume for the lenslet array "
                                   ,"ifs.spectra_positions",
                                   -370.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.distortion",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if distortion is to be measured. "
                                   "If set to true, the model is allowed to have distortion, otherwise it is rigid. "
                                   ,"ifs.spectra_positions",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.hmode",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if default model should be Y-JH (TRUE) instead of Y-J (FALSE). "
                                   "Note that this parameter is only effective if no input IFS lenslet model frame is given and the header parameter is set to false. "
                                   ,"ifs.spectra_positions",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.header",
                                   CPL_TYPE_BOOL,
                                   "Flag to set whether to try and set parameters automatically from keywords given in the header of the input files. "
                                   ,"ifs.spectra_positions",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.spectra_positions.correct_nonlin",
                                   CPL_TYPE_BOOL,
                                   "Apply non-linear correction to wavelength calibration as discovered "
                                   "necessary by D. Mesa in June 2015 "
                                   ,"ifs.spectra_positions",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ifs_spectra_positions_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ifs_spectra_positions_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ifs_spectra_positions
           structure.
 @param    self     the sph_ifs_spectra_positions recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ifs_spectra_positions_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ifs_spectra_positions_check_frames( sph_ifs_spectra_positions* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_SPEC_POS_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IFS_TAG_SPEC_POS_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_SPEC_POS_RAW);
        rerr = SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_FLAT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_flat_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_FLAT_CALIB );
    if ( ! self->master_flat_frame )
    {
        sph_error_raise( SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_flat_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_FLAT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_background_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
    if ( ! self->master_background_frame )
    {
        sph_error_raise( SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_background_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_CAL_BACKGROUND_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_background_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DARK_CALIB );
    if ( ! self->master_dark_frame )
    {
        sph_error_raise( SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_LENSLET_MODEL_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->model_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_LENSLET_MODEL_CALIB );
    if ( ! self->model_frame )
    {
        sph_error_raise( SPH_IFS_SPECTRA_POSITIONS_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract model_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_LENSLET_MODEL_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->model_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ifs_spectra_positions
           structure.
 @param    self     the sph_ifs_spectra_positions recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ifs_spectra_positions_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ifs_spectra_positions_check_params( sph_ifs_spectra_positions* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.outfilename");
    }

    self->spectra_positions_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.threshold");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.threshold");
    }

    self->threshold = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.minpix");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.minpix");
    }

    self->minpix = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.angle");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.angle");
    }

    self->angle = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.distortion");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.distortion");
    }

    self->dist = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.hmode");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.hmode");
    }

    self->hmode = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.header");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.header");
    }

    self->header = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.spectra_positions.correct_nonlin");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.spectra_positions.correct_nonlin");
    }

    self->correct_nonlin = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ifs_spectra_positions structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ifs_spectra_positions_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ifs_spectra_positions* sph_ifs_spectra_positions_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ifs_spectra_positions*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ifs_spectra_positions) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IFS_SPECTRA_POSITIONS_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ifs_spectra_positions_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ifs_spectra_positions_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ifs_spectra_positions_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ifs_spectra_positions structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ifs_spectra_positions_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ifs_spectra_positions_delete( sph_ifs_spectra_positions* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->master_flat_frame != NULL ) {
        cpl_frame_delete( self->master_flat_frame );
        self->master_flat_frame = NULL;
    }
    if ( self->master_background_frame != NULL ) {
        cpl_frame_delete( self->master_background_frame );
        self->master_background_frame = NULL;
    }
    if ( self->master_dark_frame != NULL ) {
        cpl_frame_delete( self->master_dark_frame );
        self->master_dark_frame = NULL;
    }
    if ( self->model_frame != NULL ) {
        cpl_frame_delete( self->model_frame );
        self->model_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
