/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IFS_STAR_CENTER_H_

#define SPH_IFS_STAR_CENTER_H_
#define SPH_IFS_STAR_CENTER_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ifs_star_center that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ifs_star_center_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     star_center_outfilename               ; /* The parameter of ifs.star_center.outfilename */

    int                             coll_alg                              ; /* The parameter of ifs.star_center.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of ifs.star_center.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ifs.star_center.clean_mean.reject_low */

    double                          sigma                                 ; /* The parameter of ifs.star_center.sigma */

    short                           use_waffle                            ; /* The parameter of ifs.star_center.use_waffle */

    short                           qc                                    ; /* The parameter of ifs.star_center.qc */

    short                           save_interprod                        ; /* The parameter of ifs.star_center.save_interprod */

    int                             unsharp_window                        ; /* The parameter of ifs.star_center.unsharp_window */

    int                             window_size_x                         ; /* The parameter of ifs.star_center.qc_window_x */

    int                             window_size_y                         ; /* The parameter of ifs.star_center.qc_window_y */

    cpl_frameset*                   rawframes                             ; /* The IFS_STAR_CENTER_WAFFLE_RAW frames */

    cpl_frame*                      master_dff_long1_frame                ; /* The IFS_MASTER_DFF_LONG1 frames */

    cpl_frame*                      master_dff_long2_frame                ; /* The IFS_MASTER_DFF_LONG2 frames */

    cpl_frame*                      master_dff_long3_frame                ; /* The IFS_MASTER_DFF_LONG3 frames */

    cpl_frame*                      master_dff_long4_frame                ; /* The IFS_MASTER_DFF_LONG4 frames */

    cpl_frame*                      master_dff_longbb_frame               ; /* The IFS_MASTER_DFF_LONGBB frames */

    cpl_frame*                      preamp_flat                           ; /* The IFS_PREAMP_FLAT frames */

    cpl_frame*                      master_dff_short_frame                ; /* The IFS_MASTER_DFF_SHORT frames */

    cpl_frame*                      master_ifu_flat_frame                 ; /* The IFS_IFU_FLAT_FIELD frames */

    cpl_frame*                      master_dark_frame                     ; /* The IFS_MASTER_DARK frames */

    cpl_frame*                      static_badpixel_frame                 ; /* The IFS_STATIC_BADPIXELMAP frames */

    cpl_frame*                      wave_calib_frame                      ; /* The IFS_WAVECALIB frames */

    cpl_frame*                      lenslet_distortion_frame              ; /* The IFS_DISTORTION_MAP frames */

    sph_master_frame*               dark                                  ; /* The dark_mframe data field */

    sph_master_frame*               flat                                  ; /* The flat_mframe data field */

    cpl_mask*                       stat_badpix_mask                      ; /* The mask data field */

    sph_master_frame*               qc_mframe                             ; /* The qc_mframe data field */

    sph_fctable*                    tot_fctab                             ; /* The FCTable data field */

    cpl_table*                      interntab                             ; /* The internal_table data field */

    cpl_frame*                      current_frame                         ; /* The current_frame data field */

} sph_ifs_star_center;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ifs_star_center_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ifs_star_center.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ifs_star_center* sph_ifs_star_center_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ifs_star_center_check_frames( sph_ifs_star_center* self );

sph_error_code sph_ifs_star_center_check_params( sph_ifs_star_center* parlist );

cpl_error_code sph_ifs_star_center_run( sph_ifs_star_center* self );

sph_error_code sph_ifs_star_center_delete( sph_ifs_star_center* self );
cpl_parameterlist*  sph_ifs_star_center_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ifs_star_center.c */


/* End of extra function declarations that are defined in sph_ifs_star_center_run.c */



#endif /*SPH_IFS_STAR_CENTER_H_*/
