/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ird_distortion_map.h"
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"
#include "sph_ird_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IRD_DISTORTION_MAP_GENERAL              = SPH_IRD_DISTORTION_MAP_ERR_START + 0;
sph_error_code SPH_IRD_DISTORTION_MAP_NO_VALID_DIT_LIST    = SPH_IRD_DISTORTION_MAP_ERR_START + 1;

sph_error_code SPH_IRD_DISTORTION_MAP_PARAMETER_MISSING    = SPH_IRD_DISTORTION_MAP_ERR_START + 3;
sph_error_code SPH_IRD_DISTORTION_MAP_FRAMES_MISSING       = SPH_IRD_DISTORTION_MAP_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ird_distortion_map_create_plugin ( cpl_plugin * );
static int sph_ird_distortion_map_exec_plugin ( cpl_plugin * );
static int sph_ird_distortion_map_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ird_distortion_map_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IRD_DISTORTION_MAP_RAW          1,500   The distortion map raw frames, containing a grid of point sources.\n"
    "                                        Frames are assumed to be taken with DITHERING OFF and in field stab.\n"
    "                                        (or equivalent) mode.\n"
    "IRD_MASTER_DARK                 0,  1   The master dark to subtract.\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames.\n"
    "IRD_INS_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames.\n"
    "IRD_INS_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s)\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames.\n"
    "IRD_SKY_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames.\n"
    "IRD_SKY_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames.\n"
    "IRD_FLAT_FIELD                  0,  1   The instrument flat.\n"
    "IRD_POINT_PATTERN               0,  1   The comparison point pattern as a FITS table. If this frame is\n"
    "                                        not provided the recipe will create a new comparison point pattern\n"
    "                                        from the raw frames, instead of creating a distortion map (while\n"
    "                                        the recipe will create a distortion map in this case it will be filled with zeros).\n"
    "                                        This frame can be either in FITS format or it can be a simple ASCII table\n"
    "                                        with two columns giving for each row the x and y coordinates of the expected\n"
    "                                        point positions. The coordinates should be in pixel coordinates but may be\n"
    "                                        in a coordinate frame centered onto the centre of the point pattern.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe creates a map of the distortion for the instrument. The raw frames\n"
    "are first reduced like standard science frames in field stabilised mode without\n"
    "dithering. The frame combination is simply done using a clean mean, mean or median\n"
    "combination.\n"
    "If given as input, a dark is subtracted and a flat field applied.\n"
    "\n"
    "Dark handling follows the usual strategy, see man page of sph_ird_science_dbi.\n"
    "For this recipe, providing a dark is optional - it will happily look for points\n"
    "also without subtracting anything in advance!\n"
    "\n"
    "The result frame is then analysed to detect point sources given the user detection\n"
    "threshold specified.\n"
    "Depending on whether a point pattern is given as one of the input frames or not,\n"
    "the recipe now either:\n"
    "1.  creates a new point pattern (if none was given) from the raw frames\n"
    "    or\n"
    "\n"
    "2.  measures the distortion map comparing the observed point pattern\n"
    "    with the input point pattern provided.\n"
    "\n"
    "In case that a new distortion map is created, this is done by\n"
    "\n"
    "1.  finding all points in the real image\n"
    "\n"
    "2.  making a guess of the optical axis. This is assumed to be the\n"
    "    coordinates of the point closest to the geometrical centre of the\n"
    "    point pattern. The geometrical centre of the point pattern is\n"
    "    calculated averaging the positions of all the points belonging to\n"
    "    the point pattern. The centre values are measured relative to the\n"
    "    extension of the product. In order to obtain the pixel coordinates\n"
    "    in the raw frame 1024 has to be added to the right channel x\n"
    "    coordinate.\n"
    "\n"
    "3.  shifting the input point pattern so that its most central point has\n"
    "    the same coordinates as the optical axis.\n"
    "\n"
    "    This means that the central points on real and expected point\n"
    "    pattern fall exactly on top of each other.\n"
    "\n"
    "4.  determining the distance between each observed (detected) point and\n"
    "    the closest point in the input table.\n"
    "\n"
    "5.  all points that have been found to be further than the max\n"
    "    distortion value given as parameter to the recipe are removed.\n"
    "\n"
    "6.  The resulting distortion measurements are then used to calculate two\n"
    "    2D-polynomial fits to create a distortion map in both X and Y for\n"
    "    all pixels. Each polynomial has its center of origin on the detector\n"
    "    center.\n"
    "\n"
    "The main product of the recipe is a multi-extension file that gives the\n"
    "distortion map for each IRDIS field of view separately. Other recipes\n"
    "use the polynomial fit as stored in the header of extension 0 and 8 to\n"
    "apply the distortion map.\n"
    "\n"
    "The recipe also produces a number of quality control files when\n"
    "requested to do so. The first is an image of the\n"
    "\n"
    "input point pattern, one total one and one each for the left and right\n"
    "FoVs. In addition the recipe uses the distortion\n"
    "\n"
    "map that has been calculated in the main part of the recipe to correct\n"
    "the input processed raw image. This corrected\n"
    "\n"
    "input is written out as a full detector image as well as left and right\n"
    "FoV subimages.\n"
    "\n"
    "To verify the distortion map is correct the recipe also produces\n"
    "residual distortion QC outputs when full QC output is requested.\n"
    "\n"
    "The absolute residual distortion images are named\n"
    "qc_residuals_left.fits and qc_residuals_right.fits.\n"
    "\n"
    "While these may show outliers, a high quality distortion measurement\n"
    "should yield residual images with typical values < 0.1.\n"
    "\n"
    "A stronger test of the quality of the distortion map quality can be made\n"
    "by feeding the full detector control image back into a second run of the\n"
    "distortion map recipe. The resulting distortion map then gives the\n"
    "distortion residuals – and these should all be close to 0.\n"
    "\n"
    "The polynomial fit is available as QC parameters in the distortion map.\n"
    "The polynomial fitting is performed on the point patterns shifted by the\n"
    "centre of the optical axis. The fitting generates two polynomials:\n"
    "$p_x(x,y)$ and $p_y(x,y)$ where the first provides the shift in the $x$\n"
    "direction for a point of coordinates $(x,y)$. $p_y(x,y)$ refers to the\n"
    "shift in the $y$ coordinates. The coefficients of the polynomials are\n"
    "written as QC parameters in the form “ESO DRS DIST L X COEFF i_j” where\n"
    "“L” indicates that the QC parameter belongs to the left FOV (for right\n"
    "FOV “R” is used). The letter “X” indicates that the coefficient belongs\n"
    "to $p_x(x,y)$ (“Y” is used for $p_y(x,y)$). i and j are the powers of\n"
    "$x$ and $y$, i.e. $x^iy^j$.\n"
    "\n"
    "The pin point static calibration is shifted to the closest pin-point image. This shift is stored as the estimated optical axis in the keywords ``ESO QC DISTMAP OPT AXIS X'' and ``ESO QC DISTMAP OPT AXIS Y''. Then the polynomial fit is applied as described above and saved as DISTORTION MAP, which is used in later steps of the cascade to correct the optical distortion. \n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IRD_DISTORTION_MAP                 FITS[Im(16)]   The resulting distortion map. The distortion map is saved in a FITS file with\n"
    "                                        a total of 16 extensions. The first 4 extensions contain values, badpixels, rms and weightmap\n"
    "                                        for the distortion in the x direction and the next 4 extensions the same information\n"
    "                                        for the distortion in the y direction. The first 8 extension contain the information for the left FOV\n"
    "                                        the next 8 extension the information for the right FOV.\n"
    "                                        Please also note that the image data is currently not used in subsecquent recipes -- only polynomial fit\n"
    "                                        parameters in the FITS header is used.\n"
    "IRD_POINT_PATTERN                  FITS[Table]    This frame is created only if no input point pattern was provided. The frame\n"
    "                                        contains a new table giving the positions of all points found in the raw frames.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_distortion_map Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_distortion_map.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IRD_DISTORTION_MAP_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ird_distortion_map",
                        "Creation of the total distortion map",
                        sph_ird_distortion_map_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ird_distortion_map_create_plugin,
                        sph_ird_distortion_map_exec_plugin,
                        sph_ird_distortion_map_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_distortion_map_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ird_distortion_map_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IRD_DISTORTION_MAP_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ird_distortion_map_create_test(cpl_plugin * plugin)
{
    return (int)sph_ird_distortion_map_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_distortion_map_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ird_distortion_map*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ird_distortion_map_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ird_distortion_map_run( sph_recipe );

        sph_ird_distortion_map_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_distortion_map_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ird_distortion_map struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ird_distortion_map_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ird.distortion_map.convert",
                                   CPL_TYPE_BOOL,
                                   "If this flag is set to TRUE (FALSE is default), the recipe will not create a distortion map. Instead it will convert the point pattern table which must be provided in the sof to either FITS or ASCII format. The filename specified with the outfilename parameter is used for the output. "
                                   ,"ird.distortion_map",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.distortion_map",
                                   "distortion_map.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.point_table_filename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.distortion_map",
                                   "distortion_point_table.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.distortion_map.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean. "
                                   ,"ird.distortion_map",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.distortion_map.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. "
                                   ,"ird.distortion_map",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.distortion_map.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. "
                                   ,"ird.distortion_map",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.distortion_map.threshold",
                                   CPL_TYPE_DOUBLE,
                                   "The sigma above which point sources are detected. "
                                   ,"ird.distortion_map",
                                   3.0 ,
                                   0.0,200.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.distortion_map.fitting_order",
                                   CPL_TYPE_INT,
                                   "The degree of the 2D-polynomial fitted to the distortion. "
                                   "The degree is used for both the X- and the Y-direction. "
                                   ,"ird.distortion_map",
                                   3 ,
                                   0,8);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.distortion_map.max_distortion",
                                   CPL_TYPE_DOUBLE,
                                   "The maximal distortion to correct for [pixel]. Any observed point that is found "
                                   "to be further than this threshold from its matching calibration point is excluded "
                                   "from the fitting procedure. To avoid an incorrect matching between an observed "
                                   "point and its calibration point this threshold should not be too large. "
                                   "For a grid of equidistant calibration points this upper limit is half the "
                                   "distance between two neigboring calibration points. For a calibration mask with "
                                   "73 by 73 points on a 1k by 1k detector this limit is just over 7 pixels. "
                                   ,"ird.distortion_map",
                                   7.0 ,
                                   0.0,2000.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.full-qc",
                                   CPL_TYPE_BOOL,
                                   "Full quality output wanted. Setting this to TRUE will create various QC images "
                                   "and also use the calculated distortion map to de-distort the input. "
                                   "When this flag is set, processing time of this recipe "
                                   "will increase measureably. "
                                   ,"ird.distortion_map",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.user_cent",
                                   CPL_TYPE_BOOL,
                                   "the recipe uses as optical centre the coordinate of the point that is closest to the detector "
                                   "centre of the point pattern, while for the right channel the same point is used. "
                                   ,"ird.distortion_map",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.cent_left_x",
                                   CPL_TYPE_DOUBLE,
                                   "The optical centre of the left FOV. This is only used if the user_cent parameter is set to TRUE. "
                                   ,"ird.distortion_map",
                                   512.5 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.cent_left_y",
                                   CPL_TYPE_DOUBLE,
                                   "The optical centre of the left FOV. This is only used if the user_cent parameter is set to TRUE. "
                                   ,"ird.distortion_map",
                                   512.5 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.cent_right_x",
                                   CPL_TYPE_DOUBLE,
                                   "The optical centre of the right FOV. This is only used if the user_cent parameter is set to TRUE. "
                                   ,"ird.distortion_map",
                                   512.5 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.cent_right_y",
                                   CPL_TYPE_DOUBLE,
                                   "The optical centre of the right FOV. This is only used if the user_cent parameter is set to TRUE. "
                                   ,"ird.distortion_map",
                                   512.5 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.distortion_map.align_right",
                                   CPL_TYPE_BOOL,
                                   "When set to true, the distortion correction of the right channel has a fixed shift added to it to align it with the left channel. The added shift is the difference between the optical axis of the left and right channel. "
                                   ,"ird.distortion_map",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ird_distortion_map_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ird_distortion_map_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ird_distortion_map
           structure.
 @param    self     the sph_ird_distortion_map recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ird_distortion_map_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ird_distortion_map_check_frames( sph_ird_distortion_map* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DISTORTION_MAP_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_DISTORTION_MAP_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DISTORTION_MAP_RAW);
        rerr = SPH_IRD_DISTORTION_MAP_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->dark_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    if ( ! self->dark_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    if ( ! self->insbg_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    if ( ! self->insbg_fit_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->skybg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_SKY_BG_CALIB );
    if ( ! self->skybg_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract skybg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->skybg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->skybg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_SKY_BG_FIT_CALIB );
    if ( ! self->skybg_fit_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract skybg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->skybg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->flat_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    if ( ! self->flat_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract flat_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FLAT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_POINT_PATTERN );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->point_pattern_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_POINT_PATTERN );
    if ( ! self->point_pattern_frame )
    {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract point_pattern_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_POINT_PATTERN);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->point_pattern_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ird_distortion_map
           structure.
 @param    self     the sph_ird_distortion_map recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ird_distortion_map_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_distortion_map_check_params( sph_ird_distortion_map* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.convert");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.convert");
    }

    self->convert = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.outfilename");
    }

    self->outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.point_table_filename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.point_table_filename");
    }

    self->pp_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.threshold");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.threshold");
    }

    self->threshold_sigma = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.fitting_order");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.fitting_order");
    }

    self->polyfit_order = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.max_distortion");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.max_distortion");
    }

    self->threshold_length = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.full-qc");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.full-qc");
    }

    self->full_qc = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.user_cent");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.user_cent");
    }

    self->user_cent = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.cent_left_x");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.cent_left_x");
    }

    self->cent_left_x = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.cent_left_y");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.cent_left_y");
    }

    self->cent_left_y = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.cent_right_x");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.cent_right_x");
    }

    self->cent_right_x = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.cent_right_y");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.cent_right_y");
    }

    self->cent_right_y = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.distortion_map.align_right");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.distortion_map.align_right");
    }

    self->align_right = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ird_distortion_map structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ird_distortion_map_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ird_distortion_map* sph_ird_distortion_map_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ird_distortion_map*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ird_distortion_map) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IRD_DISTORTION_MAP_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ird_distortion_map_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ird_distortion_map_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ird_distortion_map_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ird_distortion_map structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ird_distortion_map_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_distortion_map_delete( sph_ird_distortion_map* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->dark_frame != NULL ) {
        cpl_frame_delete( self->dark_frame );
        self->dark_frame = NULL;
    }
    if ( self->insbg_frame != NULL ) {
        cpl_frame_delete( self->insbg_frame );
        self->insbg_frame = NULL;
    }
    if ( self->insbg_fit_frame != NULL ) {
        cpl_frame_delete( self->insbg_fit_frame );
        self->insbg_fit_frame = NULL;
    }
    if ( self->skybg_frame != NULL ) {
        cpl_frame_delete( self->skybg_frame );
        self->skybg_frame = NULL;
    }
    if ( self->skybg_fit_frame != NULL ) {
        cpl_frame_delete( self->skybg_fit_frame );
        self->skybg_fit_frame = NULL;
    }
    if ( self->flat_frame != NULL ) {
        cpl_frame_delete( self->flat_frame );
        self->flat_frame = NULL;
    }
    if ( self->point_pattern_frame != NULL ) {
        cpl_frame_delete( self->point_pattern_frame );
        self->point_pattern_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
