/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IRD_TAGS_H_
#define SPH_IRD_TAGS_H_

#define SPH_RECIPE_NAME_IRD_MASTER_DARK              "sph_ird_master_dark"
#define SPH_RECIPE_NAME_IRD_INS_BG                   "sph_ird_ins_bg"
#define SPH_RECIPE_NAME_IRD_INSTRUMENT_FLAT          "sph_ird_instrument_flat"
#define SPH_RECIPE_NAME_IRD_WAVE_CALIB               "sph_ird_wave_calib"
#define SPH_RECIPE_NAME_IRD_SCIENCE_IMAGING          "sph_ird_science_imaging"
#define SPH_RECIPE_NAME_IRD_SCIENCE_DBI              "sph_ird_science_dbi"
#define SPH_RECIPE_NAME_IRD_SCIENCE_DPI              "sph_ird_science_dpi"
#define SPH_RECIPE_NAME_IRD_SCIENCE_SPECTROSCOPY     "sph_ird_science_spectroscopy"
#define SPH_RECIPE_NAME_IRD_GAIN                     "sph_ird_gain"
#define SPH_RECIPE_NAME_IRD_DISTORTION_MAP           "sph_ird_distortion_map"
#define SPH_RECIPE_NAME_IRD_SKY_BG                   "sph_ird_sky_bg"

#define SPH_RECIPE_NAME_IRD_STAR_CENTER              "sph_ird_star_center"
#define SPH_RECIPE_NAME_IRD_FLUX_CALIB               "sph_ird_flux_calib"
#define SPH_RECIPE_NAME_IRD_ASTROMETRY               "sph_ird_flux_astrometry"
#define SPH_RECIPE_NAME_IRD_ANDROMEDA                "sph_ird_andromeda"
#define SPH_RECIPE_NAME_IRD_LOCI                     "sph_ird_loci"
#define SPH_PIPELINE_NAME_IRDIS                    PACKAGE_STRING
#define SPH_IRD_RAW_IMAGE_EXTENSION                  0

#define SPH_IRD_TAG_DARK_RAW                         "IRD_DARK_RAW"
#define SPH_IRD_TAG_DARK_CALIB                       "IRD_MASTER_DARK"

#define SPH_IRD_TAG_INS_BG_RAW                         "IRD_INS_BG_RAW"
#define SPH_IRD_TAG_INS_BG_CALIB                       "IRD_INS_BG"
#define SPH_IRD_TAG_INS_BG_FIT_CALIB                   "IRD_INS_BG_FIT"


#define SPH_IRD_TAG_RON_RAW                          "IRD_RON_RAW"
#define SPH_IRD_TAG_RON_CALIB                        "IRD_RON"

#define SPH_IRD_TAG_DETECTOR_PERSISTENCE_OFF_RAW             "IRD_DETECTOR_PERSISTENCE_OFF_RAW"
#define SPH_IRD_TAG_DETECTOR_PERSISTENCE_ON_UNSAT_RAW        "IRD_DETECTOR_PERSISTENCE_ON_UNSAT_RAW"
#define SPH_IRD_TAG_DETECTOR_PERSISTENCE_ON_SAT_RAW          "IRD_DETECTOR_PERSISTENCE_ON_SAT_RAW"
#define SPH_IRD_TAG_DETECTOR_PERSISTENCE_CALIB               "IRD_DETECTOR_PERSISTENCE"

#define SPH_IRD_TAG_PSF_REFERENCE_RAW         "IRD_PSF_REFERENCE_RAW"
#define SPH_IRD_TAG_PSF_REFERENCE_CALIB       "IRD_PSF_REFERENCE"

#define SPH_IRD_TAG_TFF_RAW         "IRD_TFF_RAW"
#define SPH_IRD_TAG_TFF_CALIB       "IRD_TFF"
#define SPH_IRD_TAG_LSF_CALIB       "IRD_LSF"

#define SPH_IRD_TAG_SKY_BG_RAW         "IRD_SKY_BG_RAW"
#define SPH_IRD_TAG_SKY_BG_CALIB       "IRD_SKY_BG"
#define SPH_IRD_TAG_SKY_BG_FIT_CALIB   "IRD_SKY_BG_FIT"

#define SPH_IRD_TAG_GAIN_RAW                          "IRD_GAIN_RAW"
#define SPH_IRD_TAG_GAIN_CALIB                        "IRD_GAIN"
#define SPH_IRD_TAG_NONLIN_CALIB                        "IRD_NONLIN"
#define SPH_IRD_TAG_NONLINBAD_CALIB                        "IRD_NONLIN_BADPIX"

#define SPH_IRD_TAG_XTALK_RAW                        "IRD_XTALK_RAW"
#define SPH_IRD_TAG_XTALK_COEFFICIENTS               "IRD_XTALK_COEFFS"

#define SPH_IRD_TAG_FLAT_RAW                         "IRD_FLAT_FIELD_RAW"
#define SPH_IRD_TAG_FLAT_CALIB                       "IRD_FLAT_FIELD"
#define SPH_IRD_TAG_NON_LINEAR_PIXELMAP_CALIB        "IRD_NON_LINEAR_PIXELMAP"
#define SPH_IRD_TAG_INS_POL_RAW                         "IRD_INS_POL_RAW"
#define SPH_IRD_TAG_INS_POL_CALIB                       "IRD_INS_POL"

#define SPH_IRD_TAG_INS_POL_EFF_RAW                         "IRD_INS_POL_EFF_RAW"
#define SPH_IRD_TAG_INS_POL_EFF_CALIB                       "IRD_INS_POL_EFF"

#define SPH_IRD_TAG_POL_ZPA_EFF_RAW                         "IRD_POL_ZPA_EFF_RAW"
#define SPH_IRD_TAG_POL_ZPA_EFF_CALIB                       "IRD_POL_ZPA_EFF"

#define SPH_IRD_TAG_TEL_POL_OFFSET_RAW                         "IRD_TEL_POL_RAW"
#define SPH_IRD_TAG_TEL_POL_OFFSET_CALIB                       "IRD_TEL_POL"

#define SPH_IRD_TAG_INS_THROUGHPUT_CORO_RAW                         "IRD_INS_THROUGHPUT_RAW"
#define SPH_IRD_TAG_INS_THROUGHPUT_NO_CORO_RAW                         "IRD_INS_THROUGHPUT_RAW"
#define SPH_IRD_TAG_INS_THROUGHPUT_CALIB                       "IRD_INS_THROUGHPUT"
#define SPH_IRD_TAG_INS_THROUGHPUT_RAW                       "IRD_INS_THROUGHPUT_RAW"

#define SPH_IRD_TAG_FLUX_CALIB_CORO_RAW                         "IRD_FLUX_CALIB_CORO_RAW"
#define SPH_IRD_TAG_FLUX_CALIB_NO_CORO_RAW                         "IRD_FLUX_CALIB_NO_CORO_RAW"
#define SPH_IRD_TAG_FLUX_CALIB_CALIB                       "IRD_FLUX_CALIB"

#define SPH_IRD_TAG_WAVE_CALIB_RAW               "IRD_WAVECALIB_RAW"
#define SPH_IRD_TAG_WAVE_CALIB_CALIB             "IRD_WAVECALIB"

#define SPH_IRD_TAG_WAVE_CALIB_RAW               "IRD_WAVECALIB_RAW"

#define SPH_IRD_TAG_INSTR_BG_RAW               "IRD_INSTR_BG_RAW"

#define SPH_IRD_TAG_SPECTRA_RESOLUTION_RAW               "IRD_SPECTRA_RESOLUTION_RAW"
#define SPH_IRD_TAG_SPECTRA_RESOLUTION_CALIB             "IRD_SPECTRA_RESOLUTION"

#define SPH_IRD_TAG_SCIENCE_DBI_RAW                 "IRD_SCIENCE_DBI_RAW"
#define SPH_IRD_TAG_SCIENCE_DBI_CALIB               "IRD_SCIENCE_DBI"
#define SPH_IRD_TAG_SCIENCE_DBI_CALIB_LEFT          "IRD_SCIENCE_DBI_LEFT"
#define SPH_IRD_TAG_SCIENCE_DBI_CALIB_RIGHT         "IRD_SCIENCE_DBI_RIGHT"
#define SPH_IRD_TAG_SCIENCE_DBI_CALIB_LEFT_CUBE     "IRD_SCIENCE_DBI_LEFT_CUBE"
#define SPH_IRD_TAG_SCIENCE_DBI_CALIB_RIGHT_CUBE    "IRD_SCIENCE_DBI_RIGHT_CUBE"
#define SPH_IRD_TAG_SCIENCE_DBI_CALIB_TOTAL_CUBE    "IRD_SCIENCE_DBI_TOTAL_CUBE"

#define SPH_IRD_TAG_FCTABLE_CALIB               "IRD_FCTABLE"

#define SPH_IRD_TAG_ANDROMEDA_RAW           "IRD_ANDROMEDA_RAW"
#define SPH_IRD_TAG_ANDROMEDA_CALIB         "IRD_ANDROMEDA"

#define SPH_IRD_TAG_LOCI_RAW           "IRD_LOCI_RAW"
#define SPH_IRD_TAG_LOCI_CALIB         "IRD_LOCI"

#define SPH_IRD_TAG_ASTROMETRY_RAW                 "IRD_ASTROMETRY_RAW"
#define SPH_IRD_TAG_ASTROMETRY_CALIB               "IRD_ASTROMETRY"

#define SPH_IRD_TAG_SCIENCE_DPI_RAW                 "IRD_SCIENCE_DPI_RAW"
#define SPH_IRD_TAG_SCIENCE_DPI_CALIB               "IRD_SCIENCE_DPI"
#define SPH_IRD_TAG_SCIENCE_DPI_CALIB_LEFT          "IRD_SCIENCE_DPI_LEFT"
#define SPH_IRD_TAG_SCIENCE_DPI_CALIB_RIGHT         "IRD_SCIENCE_DPI_RIGHT"
#define SPH_IRD_TAG_SCIENCE_DPI_CALIB_LEFT_CUBE     "IRD_SCIENCE_DPI_LEFT_CUBE"
#define SPH_IRD_TAG_SCIENCE_DPI_CALIB_RIGHT_CUBE    "IRD_SCIENCE_DPI_RIGHT_CUBE"
#define SPH_IRD_TAG_SCIENCE_DPI_CALIB_TOTAL_CUBE    "IRD_SCIENCE_DPI_TOTAL_CUBE"

#define SPH_IRD_TAG_STAR_CENTER_RAW                 "IRD_STAR_CENTER_RAW"
#define SPH_IRD_TAG_WAFFLE_IMAGE_RAW                "IRD_STAR_CENTER_WAFFLE_RAW"
#define SPH_IRD_TAG_STAR_CENTER_QC                  "IRD_STAR_CENTER_QC"
#define SPH_IRD_TAG_STAR_CENTER_CALIB               "IRD_STAR_CENTER"

#define SPH_IRD_TAG_SCIENCE_IMAGING_RAW                 "IRD_SCIENCE_IMAGING_RAW"
#define SPH_IRD_TAG_SCIENCE_IMAGING_CALIB               "IRD_SCIENCE_IMAGING"
#define SPH_IRD_TAG_SCIENCE_IMAGING_CALIB_LEFT          "IRD_SCIENCE_IMAGING_LEFT"
#define SPH_IRD_TAG_SCIENCE_IMAGING_CALIB_RIGHT         "IRD_SCIENCE_IMAGING_RIGHT"

#define SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_RAW                 "IRD_SCIENCE_SPECTROSCOPY_RAW"
#define SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_CALIB               "IRD_SCIENCE_SPECTROSCOPY"
#define SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_CALIB_LEFT          "IRD_SCIENCE_SPECTROSCOPY_LEFT"
#define SPH_IRD_TAG_SCIENCE_SPECTROSCOPY_CALIB_RIGHT         "IRD_SCIENCE_SPECTROSCOPY_RIGHT"

#define SPH_IRD_TAG_ATMOSPHERIC_RAW                 "IRD_ATMOSPHERIC_RAW"
#define SPH_IRD_TAG_ATMOSPHERIC_CALIB               "IRD_ATMOSPHERIC"

#define SPH_IRD_TAG_DISTORTION_MAP_RAW                 "IRD_DISTORTION_MAP_RAW"
#define SPH_IRD_TAG_DISTORTION_MAP_CALIB               "IRD_DISTORTION_MAP"

#define SPH_IRD_TAG_POINT_PATTERN                      "IRD_POINT_PATTERN"
#define SPH_IRD_TAG_POINT_PATTERN_QC                   "IRD_POINT_PATTERN_QC"

#define SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB     "IRD_STATIC_BADPIXELMAP"
#define SPH_IRD_TAG_STATIC_WAFFLEMAP_CALIB       "IRD_STATIC_WAFFLEMAP"

#define SPH_IRD_TAG_DISPERSION_MODEL_CALIB       "IRD_DISPERSION_MODEL"

#define SPH_IRD_TAG_INSTRUMENT_MODEL "IRD_INSTRUMENT_MODEL"

#define SPH_IRD_TAG_FILTER_TABLE_CALIB "IRD_FILTER_TABLE"
#define SPH_IRD_TAG_PHOT_TABLE_CALIB   "IRD_PHOT_STAR_TABLE"


#define SPH_IRD_TAG_CALIB_LINES_TABLE_CALIB      "IRD_CALIBRATION_LINES_TABLE"

#define SPH_IRD_TAG_PIXEL_LINEARITY_CALIB      "IRD_PIXEL_LINEARITY_MAP"

#define SPH_IRD_MASTER_DARK_TAG_VALID_SETTINGS   "IRD_MASTER_DARK_SETTINGS"
#define SPH_IRD_GAIN_TAG_VALID_SETTINGS   "IRD_MASTER_DARK_SETTINGS"
#define SPH_IRD_RON_TAG_VALID_SETTINGS   "IRD_MASTER_DARK_SETTINGS"
#define SPH_IRD_MASTER_DETECTOR_FLAT_TAG_VALID_SETTINGS   "IRD_MASTER_DFF_SETTINGS"
#define SPH_IRD_INSTRUMENT_FLAT_TAG_VALID_SETTINGS   "IRD_MASTER_IFF_SETTINGS"
#define SPH_IRD_WAVE_CALIB_TAG_VALID_SETTINGS   "IRD_WAVE_CALIB_SETTINGS"
#define SPH_IRD_SCIENCE_DBI_TAG_VALID_SETTINGS   "IRD_SCIENCE_DBI_SETTINGS"
#define SPH_IRD_SCIENCE_IMAGING_TAG_VALID_SETTINGS   "IRD_SCIENCE_IMAGING_SETTINGS"
#endif /* SPH_IRD_TAGS_H_ */
