/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*
 * sph_zpl_common_preproc.h
 *
 *  Created on: Jul 26, 2011
 *      Author: pavlov
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include "sph_error.h"

#ifndef SPH_ZPL_COMMON_PREPROC_H_
#define SPH_ZPL_COMMON_PREPROC_H_

/*-----------------------------------------------------------------------------
 Type definition
 -----------------------------------------------------------------------------*/
/*

 typedef struct _zpl_ovsc_tables_
 {
 cpl_table* ovsc_table_cam1;
 cpl_table* ovsc_table_cam2;
 } zpl_ovsc_tables;

 */

sph_error_code sph_zpl_common_preproc_recipe_swap( cpl_frameset* rawframes,
        const char* outfilename_cam1, const char* outfilename_cam2,
        cpl_frameset* preproc_frames_cam1, cpl_frameset* preproc_frames_cam2,
		const cpl_boolean swap_even_odd_rows);

sph_error_code sph_zpl_common_preproc_recipe(cpl_frameset* rawframes,
        const char* outfilename_cam1, const char* outfilename_cam2,
        cpl_frameset* preproc_frames_cam1, cpl_frameset* preproc_frames_cam2);
sph_error_code sph_zpl_common_preproc_imaging_recipe(cpl_frameset* rawframes,
        const char* outfilename_cam1, const char* outfilename_cam2,
        cpl_frameset* preproc_frames_cam1, cpl_frameset* preproc_frames_cam2);
cpl_frameset* sph_zpl_common_preproc(cpl_frameset* inframes,
		const cpl_boolean swap_odd_even_rows)
    CPL_ATTR_ALLOC;
cpl_frameset* sph_zpl_common_preproc_imaging(cpl_frameset* inframes)
    CPL_ATTR_ALLOC;
void sph_zpl_common_preproc_update_header_with_raw_stats(
        cpl_frameset *rawset, cpl_propertylist *pl);

#endif /* SPH_ZPL_COMMON_PREPROC_H_ */
