/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * sph_zpl_framegroup.h
 *
 *  Created on: Apr 11, 2013
 *      Author: pavlov
 */

#ifndef SPH_ZPL_FRAMEGROUPS_H_
#define SPH_ZPL_FRAMEGROUPS_H_

#include <cpl.h>
#include "sph_error.h"

typedef struct _sph_zpl_framegroups_ {
    cpl_frameset* framesplus;
    cpl_frameset* framesminus;
    cpl_property* propertyplus;
    cpl_property* propertyminus;
} sph_zpl_framegroups;

sph_zpl_framegroups* sph_zpl_framegroups_new(void)
    CPL_ATTR_ALLOC;
sph_error_code sph_zpl_framegroups_set_framesplus(sph_zpl_framegroups* self,
        cpl_frameset* framesplus);
sph_error_code sph_zpl_framegroups_set_framesminus(sph_zpl_framegroups* self,
        cpl_frameset* framesminus);

sph_zpl_framegroups* sph_zpl_framegroups_create(const cpl_frameset* inframes,
        const char* czKeyword, const char* kvalue_plus,
        const char* kvalue_minus)
        CPL_ATTR_ALLOC;
sph_zpl_framegroups* sph_zpl_framegroups_create_Q(const cpl_frameset* inframes)
    CPL_ATTR_ALLOC;
sph_zpl_framegroups* sph_zpl_framegroups_create_U(const cpl_frameset* inframes)
    CPL_ATTR_ALLOC;
void sph_zpl_framegroups_delete(sph_zpl_framegroups* self);

#endif /* SPH_ZPL_FRAMEGROUPS_H_ */
