/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_ZPL_PROC_APPLY_MASTER_DARK_H_
#define SPH_ZPL_PROC_APPLY_MASTER_DARK_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_double_image.h"
#include "sph_quad_image.h"
#include "sph_error.h"

/*-----------------------------------------------------------------------------
 Function prototypes
 -----------------------------------------------------------------------------*/

sph_error_code sph_zpl_subtract_dark_double_image_scaled(sph_double_image* self,
                                            const sph_double_image* mdark);
sph_error_code sph_zpl_subtract_dark_quad_image_scaled(sph_quad_image* self,
                                            const sph_quad_image* mdark);

#endif /* SPH_ZPL_PROC_APPLY_MASTER_DARK_H_ */
