/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_ZPL_UTILS_H_
#define SPH_ZPL_UTILS_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_quad_image.h"
#include <cpl.h>

#define ZERO 1e-10
#define SMALL 1e-4
#define DELTA 1e-10
#define isZero(A) ( (A < ZERO) && (A > -ZERO) )
#define isSmall(A) ( (A < SMALL) && (A > -SMALL) )
#define isSame(A, B) ( ((A-B) < ZERO) && ((A-B) > -ZERO) )
#define isSimilar(A, B) ( ((A-B) < SMALL) && ((A-B) > -SMALL) )
#define isBetween(A, B, C) ( ((A-B) > -ZERO) && ((A-C) < ZERO) )

int sph_zpl_utils_check_format( const cpl_frameset* rawframes );
int sph_zpl_utils_check_format_frame( const cpl_frame* rawframe );
sph_master_frame*
sph_zpl_utils_calculate_master_frame_mean_weight_from_quad_image(const sph_quad_image* qi)
    CPL_ATTR_ALLOC;

sph_double_image*
sph_zpl_utils_calculate_stokes_param_double_image_from_quad_image(
        const sph_quad_image* qi)
    CPL_ATTR_ALLOC;

sph_error_code
sph_zpl_utils_apply_polarization_flat(sph_double_image* doubleimage,
                                      const sph_double_image* polarization_flat);

sph_error_code
sph_zpl_utils_apply_modem_efficiency(sph_double_image* doubleimage,
                                     const sph_master_frame* modem);

sph_master_frame*
sph_zpl_utils_calculate_polarization_efficiency(const sph_double_image* di_plus,
                                                const sph_double_image* di_minus)
    CPL_ATTR_ALLOC;

sph_master_frame*
sph_zpl_utils_calculate_polarization_offset(const sph_double_image* di_plus,
                                            const sph_double_image* di_minus)
    CPL_ATTR_ALLOC;

sph_error_code
sph_zpl_utils_get_frame_center(const cpl_frameset* inframes,
                               double* cx0, double* cy0);

#ifdef SPH_ZPL_UTILS
cpl_frame* sph_zpl_utils_remove_planes_zpl_exposure(cpl_frame* inframe,
                                                    cpl_vector* iplanes);
#endif

cpl_frameset* sph_zpl_utils_preproc(const cpl_frameset* inframes)
    CPL_ATTR_ALLOC;

cpl_frameset* sph_zpl_utils_preproc_imaging(const cpl_frameset* inframes)
    CPL_ATTR_ALLOC;

cpl_frameset* sph_zpl_utils_subtract_overscans(const cpl_frameset* inframes)
    CPL_ATTR_ALLOC;

cpl_propertylist*
sph_zpl_utils_get_camera_header(const cpl_frameset* preproc_frames,
                                const cpl_frameset* rawframes)
    CPL_ATTR_ALLOC;

cpl_frame* sph_zpl_utils_subtract_overscans_zpl_exposure(cpl_frameset* inframes,
        const char* filename)
    CPL_ATTR_ALLOC;

cpl_frame* sph_zpl_utils_subtract_overscans_zpl_exposure_imaging(
        cpl_frameset* inframes, const char* filename)
    CPL_ATTR_ALLOC;

cpl_propertylist*
sph_zpl_utils_astrometry_create_wcs_pl(const cpl_frame* frame,
                                       double xpix, double ypix)
    CPL_ATTR_ALLOC;

cpl_error_code sph_zpl_qc_add_keys(cpl_propertylist * self,
                                   const cpl_frameset * rawframes,
                                   const cpl_propertylist * srcpl);

cpl_error_code sph_zpl_qc_add_plane_keys(cpl_propertylist * self,
                                         const cpl_frameset * rawframes,
                                         cpl_boolean do_counts);

cpl_error_code sph_zpl_qc_add_odd_even_keys(cpl_propertylist * self,
                                            const cpl_frameset * rawframes,
                                            const cpl_propertylist * propl);

#define SPH_ZIMPOL_KEYWORD_QC_MEAN_DOUBLEIMAGE_LEAKAGE     	     "ESO QC DOUBLE IMAGE LEAKAGE MEAN"
#define SPH_ZIMPOL_KEYWORD_QC_MEDIAN_DOUBLEIMAGE_LEAKAGE   	     "ESO QC DOUBLE IMAGE LEAKAGE MEDIAN"
#define SPH_ZIMPOL_KEYWORD_QC_RMS_DOUBLEIMAGE_LEAKAGE  		     "ESO QC DOUBLE IMAGE LEAKAGE RMS"
#define SPH_ZIMPOL_KEYWORD_QC_NUMBER_BADPIXELS_DOUBLE_IMAGE_LEAK "ESO QC DOUBLE IMAGE LEAKAGE NUMBER BADPIXELS"

static const sph_double_image_qc_names pframe_names_leakage = {
		SPH_ZIMPOL_KEYWORD_QC_MEAN_DOUBLEIMAGE_LEAKAGE,
		SPH_ZIMPOL_KEYWORD_QC_MEDIAN_DOUBLEIMAGE_LEAKAGE,
		SPH_ZIMPOL_KEYWORD_QC_RMS_DOUBLEIMAGE_LEAKAGE,
		SPH_ZIMPOL_KEYWORD_QC_NUMBER_BADPIXELS_DOUBLE_IMAGE_LEAK
};

#define SPH_IMAGING_PFRAME_NAME_LEAKAGE_NAME "LEAKAGE"


#endif /* SPH_ZPL_UTILS_H_ */
