/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_FITS_H_
#define SPH_FITS_H_

#include "sph_error.h"
#include <cpl.h>

int sph_fits_get_nplanes( const char* self, int extnum );
int sph_fits_test_iscube( const char* self, int extnum );
int sph_fits_create_cube(const char* filenamein, int nx, int ny, int nz,
                         cpl_type_bpp bpp);
int sph_fits_update_property(const char* filename, const cpl_property* prop,
                             int extnum);
int sph_fits_append_image(const char* filename, cpl_image* image, int extnum);
int sph_fits_update_table(const char* filename, cpl_table* tab, int extnum);
int sph_fits_create_cube_extension(const char* filename, cpl_type cpltype);
int sph_fits_create_cube_head(const char* filename, int nx, int ny,
                              cpl_type cpltype);
int sph_fits_update_image(const char* filename, 
                          cpl_image* image, 
                          int plane, 
                          int extnum) ;
int sph_fits_update_timestamp(const char* filename, const char* timekeyword,
                              int extnum);
int sph_fits_update_checksum(const char* filename);


#endif /*SPH_FITS_H_*/
