/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_framecombination.h"
#ifndef SPH_GAIN_AND_RON_H_
#define SPH_GAIN_AND_RON_H_

cpl_error_code sph_gain_and_ron_vacca(cpl_frameset* collapsed_frameset,
        int order, cpl_vector** gain_out, cpl_vector** ron_out);

sph_master_frame*
sph_gain_and_ron_vacca_gain_image(cpl_frameset* collapsed_frameset);
sph_error_code
sph_gain_and_ron_get_vacca_factors(cpl_frameset* collapsed_frameset,
        cpl_vector** gain_factor, cpl_vector** ron_factor);

cpl_error_code sph_gain_run(cpl_frameset* rawframes,
        sph_collapse_algorithm coll_alg,
        cpl_parameterlist* framecomb_parameterlist,
        const char* gain_outfilename, const char* nonlin_outfilename,
        const char* nonlin_bpixfilename, cpl_frameset* inframes,
        cpl_parameterlist* inparams, cpl_frame* badpixframe,
        const char* taggain, const char* tagnonlin, const char* tagnonlinbad,
        const char* recname, const char* pipname, double lintolerance,
        int order, int save_addprod);
cpl_error_code sph_gain_and_ron_preprocessing(const cpl_frameset* rawframes,
                                              cpl_frameset* outframes);
sph_master_frame*
sph_ron_simple_single(cpl_frame* aframe,
        cpl_parameterlist* framecomb_parameterlist, double gain, double sigclip,
        double gain_factor, double ron_factor, double* ron_out, double *rms_out);

sph_error_code
sph_gain_and_ron_calc(cpl_frameset* collapsed_frameset, int order,
        cpl_propertylist* pl);

cpl_error_code sph_ron_run(cpl_frameset* rawframes,
        sph_collapse_algorithm colalg,
        cpl_parameterlist* framecomb_parameterlist, const char* ron_outfilename,
        cpl_frameset* inframes, cpl_parameterlist* inparams,
        const char* taggain, const char* recname, const char* pipname,
        int order, double gain, double sigclip, int vacca);

#endif /* SPH_GAIN_AND_RON_H_ */
