/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IFS_LENSLET_MODEL_H_
#define SPH_IFS_LENSLET_MODEL_H_
#include "cpl.h"
#include "sph_polygon.h"
#include "sph_master_frame.h"
#include "sph_point_pattern.h"
#include "sph_distortion_model.h"

extern const double SPH_IFS_INSTRUMENT_MODEL_DEROT_OFFSETSKY;
extern const double SPH_IFS_INSTRUMENT_MODEL_DEROT_OFFSETELEV;

extern const double SPH_IFS_LENSLET_MODEL_PIX_SIZE_MICRONS     ;
extern const double SPH_IFS_LENSLET_MODEL_DET_SIZE_PIX         ;
extern const double SPH_IFS_LENSLET_MODEL_DET_SIZE_MICRONS    ;
extern const double SPH_IFS_LENSLET_MODEL_MIN_LAMBDA_J    ;
extern const double SPH_IFS_LENSLET_MODEL_MAX_LAMBDA_J    ;
extern const double SPH_IFS_LENSLET_MODEL_MIN_LAMBDA_JH   ;
extern const double SPH_IFS_LENSLET_MODEL_MAX_LAMBDA_JH   ;
extern const double SPH_IFS_LENSLET_MODEL_SPEC_LENGTH_MICRONS; /* 37.57 pixels length */
extern const double SPH_IFS_LENSLET_MODEL_SPEC_WIDTH_MICRONS  ; /* 5.09 pixels width */
extern const double SPH_IFS_LENSLET_MODEL_LENSLET_SIZE_MICRONS ;
extern const int SPH_IFS_LENSLET_MODEL_LENSLETS_SIDE        ;          /* Number lenslets (side) */
extern const char* SPH_IFS_LENSLET_MODEL_SECNAME;
//extern const double sqrt3                                            ;
extern const char* SPH_IFS_LENSLET_MODEL_PIX_SIZE_NAME			;
extern const char* SPH_IFS_LENSLET_MODEL_DET_SIZE_NAME			;
extern const char* SPH_IFS_LENSLET_MODEL_LENSLET_SIZE_NAME		;
extern const char* SPH_IFS_LENSLET_MODEL_LENSLET_SIDE_NAME		;
extern const char* SPH_IFS_LENSLET_MODEL_SPEC_LENGTH_NAME		;
extern const char* SPH_IFS_LENSLET_MODEL_SPEC_WIDTH_NAME		;
extern const double SPH_IFS_LENSLET_MODEL_ROTANGLE;
extern const char* SPH_IFS_LENSLET_MODEL_ROTANGLE_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_SCALING_X_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_SCALING_Y_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_MIN_LAMBDA_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_MAX_LAMBDA_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_ZERO_OFFSET_X_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_ZERO_OFFSET_Y_NAME;
extern const char* SPH_IFS_LENSLET_MODEL_DISPERSION_NAME ;

extern const sph_error_code SPH_IFS_LENSLET_MODEL_OUTSIDE_ARRAY;

typedef struct _sph_ifs_lenslet_model_ {
    int         current_uu;
    int         current_vv;
	int 		detsize_pixels;         /* Size of detector in pixels */
	double		pixsize_microns;        /* Size of pixel in microns */
	double		detsize_microns;        /* (Full) detector size in microns */
	double		specwidth_microns;      /* Spectral width in microns */
	double		speclength_microns;     /* Spectral length in microns */
	double		lensize_microns;        /* Size of lenslets in microns */
	int			lenslets_per_side; 		/* Number of lenslets (side) */
	double		rotangle;				/* shear in the y direction in fraction */
	double		stretch_x;
	double		stretch_y;
	double 		speclength_pixels;
	double 		specwidth_pixels;
	double		zero_offsetx;
	double		zero_offsety;
    double      bigre_rot;
    double      bigre_scale;  /*The default arcsec / micron (on bigre) */
	double		dispersion;				/* The wavelength microns per pixel */
	double		minlambda;				/* Minumum wavelength on detector */
	double		maxlambda;              /* Maximum wavelength on detector */
	cpl_image*	easymap;				/* a help map for indices */
    const int*          peasymap; /* Direct read access to easymap */
	cpl_vector* lambdas;				/* Vector for reference wavelengths */
    sph_distortion_model* detector_distortion; /* Distortion model. */
    sph_distortion_model* lenslet_distortion; /* Distortion model. */
	sph_polygon*	pixelpoly;
} sph_ifs_lenslet_model;


sph_ifs_lenslet_model* sph_ifs_lenslet_model_new(void) CPL_ATTR_ALLOC;
sph_ifs_lenslet_model*
sph_ifs_lenslet_model_duplicate( sph_ifs_lenslet_model* old ) CPL_ATTR_ALLOC;
sph_ifs_lenslet_model*
sph_ifs_lenslet_model_new_from_propertylist( const cpl_propertylist* plist )
    CPL_ATTR_ALLOC;

sph_ifs_lenslet_model* sph_ifs_lenslet_model_load( const char* czFilename )
    CPL_ATTR_ALLOC;

sph_error_code sph_ifs_lenslet_model_save( const sph_ifs_lenslet_model* self,
                                           const char* czFilename );

sph_error_code
sph_ifs_lenslet_model_set_lenslet_distortion(
        sph_ifs_lenslet_model* self,
        sph_distortion_model* lenslet_dist );

sph_error_code
sph_ifs_lenslet_model_get_first( sph_ifs_lenslet_model* self,
        int* u, int* v );

sph_error_code
sph_ifs_lenslet_model_get_next( sph_ifs_lenslet_model* self,
        int* u, int* v );

cpl_propertylist*
sph_ifs_lenslet_model_get_as_propertylist( const sph_ifs_lenslet_model* self )
    CPL_ATTR_ALLOC;
    
sph_polygon*
sph_ifs_lenslet_model_get_poly( sph_ifs_lenslet_model* self, int u, int v)
    CPL_ATTR_ALLOC;

sph_error_code
sph_ifs_lenslet_model_get_index( sph_ifs_lenslet_model* self, int u, int v) ;
sph_error_code
sph_ifs_lenslet_model_get_coords( sph_ifs_lenslet_model* self, double x, double y, int* u, int* v);
sph_polygon*
sph_ifs_lenslet_model_get_spec_region( sph_ifs_lenslet_model* self, int uu, int vv);
int
sph_ifs_lenslet_model_get_nlens( sph_ifs_lenslet_model* self );
sph_polygon*
sph_ifs_lenslet_model_get_spec_region_pixel_coords(
		sph_ifs_lenslet_model* self, int uu, int vv,
		double dx, double dy );
double
sph_ifs_lenslet_model_get_lambda(
		sph_ifs_lenslet_model* self,
		sph_polygon* poly,
		int uu, int vv,
		double	ypos);

sph_error_code
sph_ifs_lenslet_model_set_wavs_specregion(
		sph_ifs_lenslet_model* self,
		sph_polygon* poly,
		int uu, int vv,
		sph_master_frame* mframe);

sph_error_code
sph_ifs_lenslet_model_create_pdt_images(
		sph_ifs_lenslet_model* self,
		cpl_image** pimage_wav,
		cpl_image** pimage_ids,
		cpl_image** pimage_ill,
		cpl_image** pimage_dw,
		double dx,
		double dy );
cpl_error_code
sph_ifs_lenslet_model_get_centre(const sph_ifs_lenslet_model* self,
                                 int u, int v, double* x, double *y);
sph_point_pattern*
sph_ifs_lenslet_model_predict_spec_loc_pp( sph_ifs_lenslet_model* self,
        double dx, double dy )
    CPL_ATTR_ALLOC;
sph_error_code
sph_ifs_lenslet_model_set_detector_distortion(
        sph_ifs_lenslet_model* self,
        sph_distortion_model* dist );

void sph_ifs_lenslet_model_delete( sph_ifs_lenslet_model* self );
cpl_vector* sph_ifs_lenslet_model_get_lambda_vector( sph_ifs_lenslet_model* self );
    
#endif /* SPH_IFS_LENSLET_MODEL_H_ */
