/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_INTERPOLATION_H_
#define SPH_INTERPOLATION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include "sph_error.h"
#include "sph_kdtree.h"

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _sph_interpolation_ {
    cpl_array*      xpositions;
    cpl_array*      ypositions;
    int             n;
    sph_kdtree*      kdtree;
    int*            indices;
    cpl_imagelist*  distances_imagelist;
    cpl_imagelist*  index_imagelist;
} sph_interpolation;

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

sph_interpolation* sph_interpolation_new(cpl_array* xpositions,
                                         cpl_array* ypositions,
                                         int n)
    CPL_ATTR_ALLOC;

void sph_interpolation_delete( sph_interpolation* self);


cpl_vector* sph_interpolation_find_closest_points(sph_interpolation* self,
                                                  double xpos,
                                                  double ypos)
    CPL_ATTR_ALLOC;

cpl_image* sph_interpolation_interpolate(const sph_interpolation* self,
                                         const cpl_array*         values)
    CPL_ATTR_ALLOC;

sph_error_code sph_interpolation_prepare_index_assocs(sph_interpolation* self,
                                                      int nx,
                                                      int ny);

#endif /* SPH_INTERPOLATION_H_ */
