/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_LENSLET_DESCRIPTOR_H_
#define SPH_LENSLET_DESCRIPTOR_H_

#include <cpl.h>
#include "sph_error.h"
#include "sph_spectrum.h"
typedef struct _sph_lenslet_descriptor
{
    short                   u;  // pixel u
    short                   v;  // pixel v
    int                     lensid; // lenslet id
    double					flat; // ifu flat field value
    cpl_vector*             lambdas; //wavelength values
    double*             values; //spectrum-values slot 1
    int*            	 bpix; //spectrum-values slot 2
    double*             rms; //spectrum-values slot 3
    double*             ncomb; //spectrum-values slot 4
} sph_lenslet_descriptor;

sph_lenslet_descriptor*
sph_lenslet_descriptor_new( int id, int u, int v, cpl_vector* lambdas );
sph_error_code
sph_lenslet_descriptor_fill_values( sph_lenslet_descriptor* self, cpl_vector* vec );
sph_error_code
sph_lenslet_descriptor_fill_bpix( sph_lenslet_descriptor* self, cpl_vector* vec );
sph_error_code
sph_lenslet_descriptor_fill_rms( sph_lenslet_descriptor* self, cpl_vector* vec );
sph_error_code
sph_lenslet_descriptor_fill_ncomb( sph_lenslet_descriptor* self, cpl_vector* vec );
sph_error_code
sph_lenslet_descriptor_fill_spec( sph_lenslet_descriptor* self, sph_spectrum* spec );
sph_error_code
sph_lenslet_descriptor_set_bad( sph_lenslet_descriptor* self );
sph_error_code
sph_lenslet_descriptor_divide_scalar( sph_lenslet_descriptor* self,
		double value);

sph_error_code
sph_lenslet_descriptor_add( sph_lenslet_descriptor* self,
		sph_lenslet_descriptor* add);
sph_error_code
sph_lenslet_descriptor_subtract( sph_lenslet_descriptor* self,
		sph_lenslet_descriptor* add);
sph_error_code
sph_lenslet_descriptor_multiply( sph_lenslet_descriptor* self,
		sph_lenslet_descriptor* add) ;
sph_error_code
sph_lenslet_descriptor_divide( sph_lenslet_descriptor* self,
		sph_lenslet_descriptor* add) ;

int
sph_lenslet_descriptor_get_overall_bad( sph_lenslet_descriptor* self );

double
sph_lenslet_descriptor_get_median( sph_lenslet_descriptor* self, double* rmsi );

double
sph_lenslet_descriptor_get_median_rms( sph_lenslet_descriptor* self );

cpl_error_code
sph_lenslet_descriptor_get_uv(sph_lenslet_descriptor* self,int* u, int* v);

void
sph_lenslet_descriptor_delete( sph_lenslet_descriptor* self );
#endif /*SPH_LENSLET_DESCRIPTOR_H_*/
