/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */


#ifndef SPH_POINT_H_
#define SPH_POINT_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "sph_error.h"
#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _sph_point_ {
    double x;
    double y;
} sph_point;

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

sph_point* sph_point_new(double x,
                         double y)
    CPL_ATTR_ALLOC;

short sph_point_ccw_test(sph_point A,
                         sph_point B,
                         sph_point C);

void sph_point_delete( sph_point* self);

sph_error_code sph_point_shift(sph_point* self, double dx, double dy);

sph_error_code sph_point_rotate_around(sph_point* self,
                                       double x,
                                       double y,
                                       double cosangle,
                                       double sinangle,
                                       double dx,
                                       double dy);

cpl_boolean sph_point_same_side(const sph_point* l1,
                                const sph_point* l2,
                                const sph_point* p1,
                                const sph_point* p2)
    CPL_ATTR_NONNULL;

cpl_boolean sph_point_same_side_(const sph_point* l1,
                                 const sph_point* l2,
                                 const sph_point* p1,
                                 const sph_point* p2)
    CPL_ATTR_NONNULL;

/*----------------------------------------------------------------------------*/
/**
   @brief  Copy one point to another
   @param  self  Pointer to the destination point
   @param  other Pointer to the source point
   @return void

 */
/*----------------------------------------------------------------------------*/
#define sph_point_copy(self, other) do {                \
        (void)memcpy(self, other, sizeof(sph_point));   \
    } while (0)

#endif /*SPH_POINT_H_*/
