/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_master_frame.h"
#include "sph_transform.h"
#include "sph_ird_instrument_model.h"
#include "sph_cube.h"
#include "sph_common_science.h"
#ifndef SPH_SIMPLE_ADI_H_
#define SPH_SIMPLE_ADI_H_

typedef struct _sph_simple_adi_ {
    sph_ird_instrument_model*       irdmodel;
    sph_master_frame*               speckleframe;
    cpl_vector*                     current_cube_angles;
    sph_transform*                  transform;
    cpl_frameset*                   current_frameset;
    cpl_imagelist*                  current_imlist;
    cpl_imagelist*                  current_bmaplist;
    cpl_imagelist*                  current_wmaplist;
    sph_cube*                       result_cube;
    cpl_frameset*                       result_frameset;
    cpl_imagelist*                  result_imlist;
    cpl_imagelist*                  result_bmaplist;
    cpl_imagelist*                  result_wmaplist;
    int                             currentplane;
    int                             ext_im;
    int                             ext_bp;
    int                             ext_wm;
} sph_simple_adi;

sph_simple_adi*
sph_simple_adi_new(
        sph_transform*  transform);

void
sph_simple_adi_delete( sph_simple_adi* self);

sph_ird_instrument_model*
sph_simple_adi_get_ird_model( sph_simple_adi* self);

sph_error_code
sph_simple_adi_set_ird_model( sph_simple_adi* self,
        sph_ird_instrument_model* model);

sph_transform*
sph_simple_adi_get_transform( sph_simple_adi* self);

sph_master_frame*
sph_simple_adi_process_imlists(
        sph_simple_adi* self,
        sph_collapse_algorithm coll_alg );

sph_error_code
sph_simple_adi_process(sph_simple_adi* self );

sph_error_code
sph_simple_adi_set_transform( sph_simple_adi* self,
        sph_transform* transform);

cpl_vector*
sph_simple_adi_get_angles( sph_simple_adi* self);

sph_error_code
sph_simple_adi_set_angles( sph_simple_adi* self,
        cpl_vector* angles);

sph_master_frame*
sph_simple_adi_get_speckle_frame( sph_simple_adi* self);

sph_error_code
sph_simple_adi_set_speckle_frame( sph_simple_adi* self,
        sph_master_frame* specke);

sph_error_code
sph_simple_adi_set_current_cube_frame( sph_simple_adi* self,
        cpl_frame* cube_frame,
        int ext_im,
        int ext_bp,
        int ext_wm);

sph_error_code
sph_simple_adi_set_current_frameset( sph_simple_adi* self,
        cpl_frameset* no_cubes_frameset,
        int ext_im,
        int ext_bp,
        int ext_wm);

sph_error_code
sph_simple_adi_calculate_speckle_frame( sph_simple_adi* self );

sph_error_code
sph_simple_adi_append_image( sph_simple_adi* self,
        cpl_image* image,
        cpl_image* bpix,
        cpl_image* weight,
        double angle);

sph_error_code
sph_simple_adi_append_imagelist( sph_simple_adi* self,
        cpl_imagelist* images,
        cpl_imagelist* bpixs,
        cpl_imagelist* weights,
        cpl_vector* angles);

cpl_frame*
sph_simple_adi_process_single_cube( cpl_frame* incube_frame,
        sph_master_frame* speckleframe,
        cpl_vector* angles,
        sph_transform* transform,
        sph_ird_instrument_model* irdmodel,
        int ext_im,
                int ext_bp,
                int ext_wm);

cpl_frameset*
sph_simple_adi_process_cubes( cpl_frameset* incube_frames,
        cpl_frameset* origframes,
        cpl_vector* angles,
        sph_transform* transform,
        sph_ird_instrument_model* irdmodel,
        int ext_im,
                int ext_bp,
                int ext_wm,
                int full_frameset_collapse);
#endif /* SPH_SIMPLE_H_ */
