#ifndef SPH_ZPL_SCIENCE_POL_PRODUCT_H_
#define SPH_ZPL_SCIENCE_POL_PRODUCT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_double_image.h"

#include <cpl.h>
#include "sph_error.h"

typedef struct{
	sph_double_image * image;
	cpl_propertylist * header;
	cpl_frame * inherit_frame;
	char * out_filename;
	char * tag;
}sph_zpl_science_pol_product;

sph_zpl_science_pol_product* sph_zpl_science_pol_product_create(sph_master_frame* mf_odd, sph_master_frame* mf_even);

sph_error_code sph_zpl_science_pol_product_delete(
		sph_zpl_science_pol_product* prod);

sph_zpl_science_pol_product * sph_zpl_science_pol_product_duplicate(sph_zpl_science_pol_product * p);

void sph_zpl_science_pol_product_set_tag(sph_zpl_science_pol_product * p, const char * s);
void sph_zpl_science_pol_product_set_filename(sph_zpl_science_pol_product * p, const char * s);
void sph_zpl_science_pol_product_set_inherit_frame(sph_zpl_science_pol_product * p, const cpl_frame * frame);
void sph_zpl_science_pol_product_wrap_header(sph_zpl_science_pol_product * p, cpl_propertylist * header);


#endif
