/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_TEST_IRDIS_MODEL_H_
#define SPH_TEST_IRDIS_MODEL_H_

#include <cpl.h>
#include "sph_pixel_description_table.h"
#include "sph_test_ngc_ir_simulator.h"
enum _sph_test_irdis_insmode_ {
    SPH_TEST_IRDIS_INSMODE_CI = 0,
    SPH_TEST_IRDIS_INSMODE_DBI = 1,
    SPH_TEST_IRDIS_INSMODE_DPI = 2,
    SPH_TEST_IRDIS_INSMODE_SPEC_LRS = 3,
    SPH_TEST_IRDIS_INSMODE_SPEC_MRS = 4
};
typedef enum _sph_test_irdis_insmode_ sph_test_irdis_insmode;

typedef struct _sph_test_irdis_model_ {
    cpl_frameset* frameset;
    sph_test_irdis_insmode insmode; // the instrument mode;
    cpl_vector* common_filter_lambdas; // array of common filter wavelengths
    cpl_vector* common_filter_transmission; // array of common filter transmission
    const char* common_filter_name; // array of names of common filters
    cpl_vector* dual_filter_lambdas_left; // array of dual filter wavelengths left
    cpl_vector* dual_filter_lambdas_right; // array of dual filter wavelengths right
    cpl_vector* dual_filter_transmission_left; // array of dual filter transmission left
    cpl_vector* dual_filter_transmission_right; // array of dual filter transmission right
    const char* dual_filter_name_left; // array of names of common filters
    const char* dual_filter_name_right; // array of names of common filters
    cpl_vector* nd_filter_lambdas; // array of common filter wavelengths
    cpl_vector* nd_filter_attenuation; // array of nd filters attenuation factor
    const char* nd_filter_name; // array of names of nd filters
    int current_common_filterid;
    int current_dual_filterid_left;
    int current_dual_filterid_right;
    int current_nd_filterid;
    double centre_right_x;
    double centre_left_x;
    double centre_right_y;
    double centre_left_y;
    double radius_left;
    double radius_right;
    int nx; // size of images created -- should correspond
    int ny; // to the size of the sub-windows!
    int win_minx; // window of projection for optical
    int win_miny; // paths in coordinates on the created images
    int det_pixels_x; // the number of pixels of detector readout
    int det_pixels_y; // the number of pixels of detector readout
    int specwin_minx;
    int specwin_miny;
    int specwin_maxx;
    int specwin_maxy;
    double spec_minlambda;
    double spec_maxlambda; //only applies to top row if dl/dy!=0.
    double spec_dl_over_dx;

} sph_test_irdis_model;

sph_test_irdis_model*
sph_test_irdis_model_new(sph_test_ngc_ir_simulator* ngc);

sph_test_irdis_model*
sph_test_irdis_model_new_constvalue(sph_test_ngc_ir_simulator* ngc);

void sph_test_irdis_model_set_subwindow_size(sph_test_irdis_model* self, int nx,
        int ny);

void sph_test_irdis_model_set_window_pos(sph_test_irdis_model* self, int minx,
        int miny);

void sph_test_irdis_model_set_left_illumcircle_centre(
        sph_test_irdis_model* self, double x, double y);

void sph_test_irdis_model_set_left_illumcircle_radius(
        sph_test_irdis_model* self, double rad);

void sph_test_irdis_model_set_right_illumcircle_centre(
        sph_test_irdis_model* self, double x, double y);

void sph_test_irdis_model_set_right_illumcircle_radius(
        sph_test_irdis_model* self, double rad);

void sph_test_irdis_model_set_common_filter(sph_test_irdis_model* self,
        int filterid, const char* filtername, cpl_vector* lambdas,
        cpl_vector* transmissions);

void sph_test_irdis_model_set_left_filter(sph_test_irdis_model* self,
        int filterid, const char* filtername, cpl_vector* lambdas,
        cpl_vector* transmissions);

void sph_test_irdis_model_set_right_filter(sph_test_irdis_model* self,
        int filterid, const char* filtername, cpl_vector* lambdas,
        cpl_vector* transmissions);

void sph_test_irdis_model_set_nd_filter(sph_test_irdis_model* self,
        int filterid, const char* filtername, cpl_vector* lambdas,
        cpl_vector* transmissions);

void sph_test_irdis_model_set_mode(sph_test_irdis_model* self,
        sph_test_irdis_insmode mode);

cpl_image*
sph_test_irdis_model_get_image_left(sph_test_irdis_model* self, cpl_image* inim);
cpl_image*
sph_test_irdis_model_get_image_right(sph_test_irdis_model* self,
        cpl_image* inim);

cpl_image*
sph_test_irdis_model_process_image_left_right(sph_test_irdis_model* self,
        cpl_image* impupil, cpl_image* imright);

cpl_image*
sph_test_irdis_model_process_image(sph_test_irdis_model* self,
        cpl_image* impupil);

sph_pixel_description_table*
sph_test_irdis_model_create_pdt_single_window(sph_test_irdis_model* self);
sph_pixel_description_table*
sph_test_irdis_model_create_pdt(sph_test_irdis_model* self);
void
sph_test_irdis_model_apply_dbi_mask(sph_test_irdis_model* self,
        cpl_image* animage);
void
sph_test_irdis_model_apply_ci_mask(sph_test_irdis_model* self,
        cpl_image* animage);
void
sph_test_irdis_model_digest_frames(sph_test_irdis_model* self,
        cpl_frameset* frames);
cpl_image*
sph_test_irdis_model_create_instrument_flat_image(sph_test_irdis_model* self,
        int ndit, double exptime);
void
sph_test_irdis_model_delete(sph_test_irdis_model* self);

#endif /* SPH_TEST_IRDIS_MODEL_H_ */
