/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#include <math.h>
#include "sph_error.h"
#include "sph_test.h"
#include "sph_test_ngc_ccd_simulator.h"
#include "sph_master_frame.h"
#include "sph_ird_tags.h"
#include "sph_test_pupilimage_creator.h"
#include "sph_utils.h"
#include "sph_test_image_tools.h"
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

static
int cutest_init_test_ngc_simulator_testsuite(void) {
    /*--------------------------------------------------------------------
     * -    Prepare CPL and error logging
     * -------------------------------------------------------------------*/
    return sph_test_nop_code();
}

static
int cutest_clean_test_ngc_simulator_testsuite(void) {
    sph_error_dump(SPH_ERROR_ERROR);
    return sph_end_test();
}

static
void cutest_test_ngc_simulator_ccd_create_raw_frameset_poisson(void) {
}

/*----------------------------------------------------------------------------*/
/**
 */
/*----------------------------------------------------------------------------*/
static
void cutest_test_ngc_simulator_ccd_new(void) {
    sph_test_ngc_ccd_simulator* fc = NULL;

    fc = sph_test_ngc_ccd_simulator_new();
    cpl_test_assert( fc);

    sph_test_ngc_ccd_simulator_delete(fc);
    fc = NULL;

    return;
}
/*----------------------------------------------------------------------------*/
/**
 */
/*----------------------------------------------------------------------------*/
static
void cutest_test_ngc_simulator_ccd_create_raw_frameset(void) {
    sph_test_ngc_ccd_simulator* fc = NULL;
    cpl_frameset* frames = NULL;
    cpl_frame* inframe = NULL;
    cpl_frameset* inframeset = NULL;
    cpl_image* image = sph_test_image_tools_create_flat_image_double(256, 256,
            1.0);

    cpl_test_nonnull( image );
    inframe = sph_test_frame_image(image, CPL_TYPE_DOUBLE,
            SPH_TEST_PUPILIMAGE_TAG, CPL_FRAME_GROUP_RAW);
    inframeset = cpl_frameset_new();
    cpl_test_nonnull( inframe );
    cpl_test_nonnull( inframeset );
    cpl_frameset_insert(inframeset, inframe);
    fc = sph_test_ngc_ccd_simulator_new();
    cpl_test_assert( fc);
    frames = sph_test_ngc_ccd_simulator_create_raw_frameset_many(fc, inframeset,
            1.0, "zpl_raw_darks", NULL, SPH_IRD_TAG_DARK_RAW);
    cpl_test_assert( frames);
    cpl_test_eq(cpl_frameset_get_size( frames ), 1);
    sph_test_ngc_ccd_simulator_delete(fc);
    fc = NULL;
    sph_test_cleanup_testfiles();
    cpl_frameset_delete(inframeset);
    cpl_frameset_delete(frames);
    cpl_image_delete(image);
    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests of techcal_master_dark recipe and associated functions
 */
/*----------------------------------------------------------------------------*/
int main(void) {
    const void* pSuite = NULL;


    (void)sph_test_init();


    pSuite = sph_add_suite("sph_test_famecreator_irdis",
            cutest_init_test_ngc_simulator_testsuite,
            cutest_clean_test_ngc_simulator_testsuite);
    cpl_test_nonnull(pSuite);

    if (NULL
            == sph_test_do(pSuite, "sph_test_ngc_ccd_simulator_new",
                    cutest_test_ngc_simulator_ccd_new)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite,
                    "sph_test_ngc_ccd_simulator_create_raw_frameset",
                    cutest_test_ngc_simulator_ccd_create_raw_frameset)) {
        return sph_test_get_error();
    }
    if (NULL
            == sph_test_do(pSuite,
                    "sph_test_ngc_ccd_simulator_create_raw_frameset_poisson",
                    cutest_test_ngc_simulator_ccd_create_raw_frameset_poisson)) {
        return sph_test_get_error();
    }

    return sph_test_end();
}

/**@}*/
