/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_test_ngc_ir_simulator.h"
#include "sph_test_ifs_instrument_model.h"
#include "sph_ldt.h"
#ifndef SPH_IFS_TEST_FIXTURES_CALIB_PRODUCTS_H_
#define SPH_IFS_TEST_FIXTURES_CALIB_PRODUCTS_H_

cpl_frame*
sph_ifs_test_fixtures_calib_products_master_dark(sph_test_ngc_ir_simulator* ngc);

cpl_frame* sph_ifs_test_fixtures_calib_products_wave_calib(
        sph_test_ifs_instrument_model* insmodel);
cpl_frame* sph_ifs_test_fixtures_calib_products_pdt(
        sph_test_ifs_instrument_model* insmodel);

cpl_frame* sph_ifs_test_fixtures_calib_products_dff_short(
        sph_test_ngc_ir_simulator* ngc);
cpl_frame* sph_ifs_test_fixtures_calib_products_dff_long(
        sph_test_ngc_ir_simulator* ngc, double min, double max, double lambda,
        int lamp_id);
cpl_frame* sph_ifs_test_fixtures_calib_products_ifu_flat(
        sph_test_ngc_ir_simulator* ngc, sph_test_ifs_instrument_model* insmodel);

sph_ldt*
sph_ifs_test_fixtures_calib_products_simple_ldt(sph_test_ngc_ir_simulator * ngc,
        sph_test_ifs_instrument_model * insmodel);
#endif /* SPH_IFS_TEST_FIXTURES_CALIB_PRODUCTS_H_ */
