/* $Id: $
 *
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <cpl.h>

#include "cutest_zpl_preproc.h"
#include "sph_zpl_preproc.h"
#include "sph_zpl_utils.h"
#include "sph_utils.h"
#include "sph_zpl_keywords.h"
#include "sph_zpl_tags.h"
#include "sph_common_keywords.h"
#include "sph_keyword_manager.h"
#include "sph_filemanager.h"
#include "sph_test_zpl_simulator.h"
#include "sph_error.h"
#include "sph_test.h"
#include "sph_test_image_tools.h"

#include <math.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup Unit test of the polarimetric pre-processing
 * 			 recipe and associated functions.
 *
 */
/*----------------------------------------------------------------------------*/

static int cutest_init_preproc_testsuite(void) {
    /*--------------------------------------------------------------------
     * -    Prepare CPL and error logging
     * -------------------------------------------------------------------*/
    return sph_test_nop_code();
}

static int cutest_clean_preproc_testsuite(void) {
    return sph_end_test();
}

void cutest_zpl_preproc_run(void) {
    sph_zpl_preproc* zpl_preproc = NULL;
    cpl_parameterlist* inparams = NULL;
    cpl_frameset* inframes = NULL;
    cpl_frame* inframe = NULL;
    sph_error_code rerr = CPL_ERROR_NONE;

    inframe = cpl_frame_new();
    if (inframe) {
        cpl_frame_set_tag(inframe, SPH_ZPL_TAG_PREPROC_RAW);
        cpl_frame_set_group(inframe, CPL_FRAME_GROUP_RAW);
        cpl_frame_set_filename(
                inframe,
                "/home/pavlov/prj/sphere/data/data-15.04.2011/110328/fastpol/DRHfpflatH000.fits");
        //cpl_frame_set_filename( inframe, "../../../../pySphere/example/ZIMPOL/test_double_ext.fits" );

        //cpl_frame_set_filename( frame, "ZIMPOL/data/test_double_ext.fits" );
        //cpl_frame_set_filename( frame, "pol250_10sec_nshut.fits" );
    }

    inframes = cpl_frameset_new();
    rerr = cpl_frameset_insert(inframes, inframe);
    cpl_test_eq_error(rerr, CPL_ERROR_NONE);

    inparams = sph_zpl_preproc_create_paramlist();
    zpl_preproc = sph_zpl_preproc_new(inframes, inparams);
    cpl_test_nonnull( zpl_preproc );

    rerr = sph_zpl_preproc_run(zpl_preproc);
    cpl_test_eq_error(rerr, CPL_ERROR_NONE);

    rerr = sph_zpl_preproc_delete(zpl_preproc);
    cpl_test_error(CPL_ERROR_NONE);

    return;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit tests of  recipe polarimetric pre-processing
 * 		   recipe and associated functions.
 */
/*----------------------------------------------------------------------------*/
int main(void) {
    int result = 0;

    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("sph_zpl_preproc_run", cutest_init_preproc_testsuite,
            cutest_clean_preproc_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }



    /*
     if ( NULL == sph_test_do(pSuite, "zpl_preproc_run",
     cutest_zpl_preproc_run ) )
     {
     return sph_test_get_error();
     }
     */
    /* Run all tests using the CUnit Basic interface */
    sph_test_nop_int( 0);
    sph_test_nop_char("results.txt");
    result = sph_test_end();
    return result;
}

/**@}*/
