from edps import classification_rule

from . import zimpol_rules as rules

########################
# CLASSIFICATION RULES #
########################
# raw data classification: cls_
# product classification rules have the same name as the PRO.CATG
# static calibration classification: _class
# technical and test data
cls_zpl_technical = classification_rule("IFS_TECHNICAL_RAW", rules.is_zpl_technical)
cls_zpl_test = classification_rule("IFS_TEST_RAW", rules.is_zpl_test)
# acquisition
cls_zpl_acq_object = classification_rule("ZPL_SCIENCE_IMAGING_RAW", rules.is_zpl_acq_object)
cls_zpl_acq_dark = classification_rule("ZPL_DARK_IMAGING_RAW", rules.is_zpl_acq_dark)
cls_zpl_acq_flat = classification_rule("ZPL_FLAT_FIELD_IMAGING_RAW", rules.is_zpl_acq_flat)
# imaging calibrations @@@
cls_zpl_bias_img = classification_rule("ZPL_BIAS_IMAGING_RAW", rules.is_zpl_bias_img)
ZPL_MASTER_BIAS_IMAGING_CAM1 = classification_rule("ZPL_MASTER_BIAS_IMAGING_CAM1")
ZPL_MASTER_BIAS_IMAGING_CAM2 = classification_rule("ZPL_MASTER_BIAS_IMAGING_CAM2")
cls_zpl_dark_img = classification_rule("ZPL_DARK_IMAGING_RAW", rules.is_zpl_dark_img)
ZPL_MASTER_DARK_IMAGING_CAM1 = classification_rule("ZPL_MASTER_DARK_IMAGING_CAM1")
ZPL_MASTER_DARK_IMAGING_CAM2 = classification_rule("ZPL_MASTER_DARK_IMAGING_CAM2")
cls_zpl_flat_img = classification_rule("ZPL_INT_FLAT_FIELD_IMAGING_RAW", rules.is_zpl_flat_img)
ZPL_INT_FLAT_FIELD_IMAGING_CAM1 = classification_rule("ZPL_INT_FLAT_FIELD_IMAGING_CAM1")
ZPL_INT_FLAT_FIELD_IMAGING_CAM2 = classification_rule("ZPL_INT_FLAT_FIELD_IMAGING_CAM2")
cls_zpl_standard_flux_img = classification_rule("ZPL_SCIENCE_IMAGING_RAW", rules.is_zpl_standard_flux_img)
cls_zpl_distortion_img = classification_rule("ZPL_LAMP_ASTROMETRY_IMAGING_RAW", rules.is_zpl_distortion_img)
cls_zpl_standard_astrometry_img = classification_rule("ZPL_SCIENCE_IMAGING_RAW", rules.is_zpl_standard_astrometry_img)
# imaging science data
cls_zpl_science_img = classification_rule("ZPL_SCIENCE_IMAGING_RAW", rules.is_zpl_science_img)
cls_zpl_science_flux_img = classification_rule("ZPL_SCIENCE_IMAGING_RAW", rules.is_zpl_science_flux_img)
ZPL_SCIENCE_IMAGING_REDUCED_CAM1 = classification_rule("ZPL_SCIENCE_IMAGING_REDUCED_CAM1")
ZPL_SCIENCE_IMAGING_REDUCED_CAM2 = classification_rule("ZPL_SCIENCE_IMAGING_REDUCED_CAM2")
cls_zpl_coronagraph_center_img = classification_rule("ZPL_STAR_CENTER_IMG_RAW", rules.is_zpl_coronagraph_center_img)
ZPL_STAR_CENTER_IMG_CAM1 = classification_rule("ZPL_STAR_CENTER_IMG_CAM1")
ZPL_STAR_CENTER_IMG_CAM2 = classification_rule("ZPL_STAR_CENTER_IMG_CAM2")

# polarimetric calibrations
cls_zpl_dark_pol = classification_rule("ZPL_DARK_RAW", rules.is_zpl_dark_pol)
ZPL_MASTER_DARK_CAM1 = classification_rule("ZPL_MASTER_DARK_CAM1")
ZPL_MASTER_DARK_CAM2 = classification_rule("ZPL_MASTER_DARK_CAM2")
cls_zpl_bias_pol = classification_rule("ZPL_BIAS_RAW", rules.is_zpl_bias_pol)
ZPL_MASTER_BIAS_CAM1 = classification_rule("ZPL_MASTER_BIAS_CAM1")
ZPL_MASTER_BIAS_CAM2 = classification_rule("ZPL_MASTER_BIAS_CAM2")
cls_zpl_flat_pol = classification_rule("ZPL_INT_FLAT_FIELD_RAW", rules.is_zpl_flat_pol)
ZPL_INT_FLAT_FIELD_MASTER_CAM1 = classification_rule("ZPL_INT_FLAT_FIELD_MASTER_CAM1")
ZPL_INT_FLAT_FIELD_MASTER_CAM2 = classification_rule("ZPL_INT_FLAT_FIELD_MASTER_CAM2")
cls_zpl_distortion = classification_rule("ZPL_LAMP_ASTROMETRY_RAW", rules.is_zpl_distortion_pol)
cls_zpl_modem_eff = classification_rule("ZPL_MODEM_EFF_RAW", rules.is_zpl_modemeff)
ZPL_MODEM_EFF_CAM1 = classification_rule("ZPL_MODEM_EFF_CAM1")
ZPL_MODEM_EFF_CAM2 = classification_rule("ZPL_MODEM_EFF_CAM2")
# polarimetric standard stars
cls_zpl_standard_pol0 = classification_rule("ZPL_SCIENCE_P1_RAW", rules.is_zpl_standard_pol0)
cls_zpl_standard_polhigh = classification_rule("ZPL_SCIENCE_P1_RAW", rules.is_zpl_standard_polhigh)
# polarimetric science data
cls_zpl_science_flux_p1 = classification_rule("ZPL_SCIENCE_P1_RAW", rules.is_zpl_science_flux_pol_p1)
ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM1 = classification_rule("ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM1")
ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM2 = classification_rule("ZPL_SCIENCE_P1_REDUCED_QPLUS_CAM2")
cls_zpl_coronagraph_center_pol = classification_rule("ZPL_STAR_CENTER_POL_RAW", rules.is_zpl_coronagraph_center_pol)
ZPL_STAR_CENTER_POL_CAM1 = classification_rule("ZPL_STAR_CENTER_POL_CAM1")
ZPL_STAR_CENTER_POL_CAM2 = classification_rule("ZPL_STAR_CENTER_POL_CAM2")
cls_zpl_science_p1 = classification_rule("ZPL_SCIENCE_P1_RAW", rules.is_zpl_science_pol_p1)
cls_zpl_science_flux_p2 = classification_rule("ZPL_SCIENCE_P23_RAW", rules.is_zpl_science_flux_pol_p2)
ZPL_SCIENCE_P23_REDUCED_QPLUS_CAM1 = classification_rule("ZPL_SCIENCE_P23_REDUCED_QPLUS_CAM1")
ZPL_SCIENCE_P23_REDUCED_QPLUS_CAM2 = classification_rule("ZPL_SCIENCE_P23_REDUCED_QPLUS_CAM2")
cls_zpl_science_p2 = classification_rule("ZPL_SCIENCE_P23_RAW", rules.is_zpl_science_pol_p2)

# static calibrations polarimetry / imaging
ZPL_PHOT_STAR_TABLE = classification_rule("ZPL_PHOT_STAR_TABLE")
ZPL_FILTER_TABLE = classification_rule("ZPL_FILTER_TABLE")
ZPL_POL_CORRECT_TABLE = classification_rule("ZPL_POL_CORRECT_TABLE")
ZPL_POLHIGH_STAR_TABLE = classification_rule("ZPL_POLHIGH_STAR_TABLE")
