from edps import (
    data_source,
    SAME_NIGHT,
    ONE_MONTH,
    QUARTERLY,
    UNLIMITED,
    IN_THE_PAST,
)

from . import sphere_keywords as kwd
from .sphere_rules import TEN_DAYS, TWELVE_DAYS
from .zimpol_classification import *

######################
#     DATA SOURCES   #
######################
# Imaging
zpl_raw_bias_img = (data_source("RAW_BIAS_IMG")
                    .with_classification_rule(cls_zpl_bias_img)
                    .with_setup_keywords(rules.setupkwd_zpl_bias)
                    .with_grouping_keywords(rules.grpkwd_zpl_bias)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TEN_DAYS, level=0)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TWELVE_DAYS, level=1)
                    .build())

zpl_raw_dark_img = (data_source("RAW_DARK_IMG")
                    .with_classification_rule(cls_zpl_dark_img)
                    .with_setup_keywords(rules.setupkwd_zpl_dark)
                    .with_grouping_keywords([kwd.arcfile])
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TEN_DAYS, level=0)
                    .build())

zpl_raw_flat_img = (data_source("RAW_FLAT_IMG")
                    .with_classification_rule(cls_zpl_flat_img)
                    .with_setup_keywords(rules.setupkwd_zpl_flat)
                    .with_grouping_keywords(rules.grpkwd_zpl_flat)
                    .with_match_function(rules.zpl_ff1_cond, time_range=TEN_DAYS, level=0)
                    .with_match_function(rules.zpl_ff2_cond, time_range=TEN_DAYS, level=0)
                    .with_match_function(rules.zpl_ff1_cond, time_range=TWELVE_DAYS, level=1)
                    .with_match_function(rules.zpl_ff2_cond, time_range=TWELVE_DAYS, level=1)
                    .with_match_function(rules.zpl_ff1_cond, time_range=UNLIMITED, level=3)
                    .with_match_function(rules.zpl_ff2_cond, time_range=UNLIMITED, level=3)
                    .build())

zpl_raw_distortion = (data_source("RAW_LAMP_ASTROMETRY")
                      .with_classification_rule(cls_zpl_distortion)
                      .with_setup_keywords(rules.setupkwd_zpl_flat)
                      .with_grouping_keywords([kwd.tpl_start])
                      .build())

zpl_raw_std_flux_img = (data_source("RAW_PHOT_STANDARD_IMG")
                        .with_classification_rule(cls_zpl_standard_flux_img)
                        .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                        .with_grouping_keywords([kwd.arcfile])
                        .with_match_keywords([kwd.instrume, kwd.ins3_opti5_name, kwd.ins3_opti6_name],
                                             time_range=ONE_MONTH, level=0)
                        .build())

zpl_raw_astrometry_std_img = (data_source("RAW_ASTROMETRY_STANDARD_IMG")
                              .with_classification_rule(cls_zpl_standard_astrometry_img)
                              .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                              .with_grouping_keywords([kwd.arcfile])
                              .with_match_keywords([kwd.instrume, kwd.ins3_opti5_name, kwd.ins3_opti6_name],
                                                   time_range=QUARTERLY, level=0)
                              .build())

zpl_raw_science_flux_img = (data_source("RAW_SCIENCE_FLUX_IMG")
                            .with_classification_rule(cls_zpl_science_flux_img)
                            .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                            .with_grouping_keywords(rules.grpkwd_zpl_science_ctr_flx)
                            .with_match_keywords(rules.matchkwd_zpl_star_cal, time_range=SAME_NIGHT, level=0)
                            .build())

zpl_raw_science_center_img = (data_source("RAW_SCIENCE_CENTER_IMG")
                              .with_classification_rule(cls_zpl_coronagraph_center_img)
                              .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                              .with_grouping_keywords(rules.grpkwd_zpl_science_ctr_flx)
                              .with_match_keywords(rules.matchkwd_zpl_star_cal, time_range=SAME_NIGHT, level=0)
                              .build())

zpl_raw_science_img = (data_source("RAW_SCIENCE_IMG")
                       .with_classification_rule(cls_zpl_science_img)
                       .with_setup_keywords(rules.setupkwd_zpl_science_obj)
                       .with_grouping_keywords(rules.grpkwd_zpl_science_obj)
                       .build())
# polarimetry
zpl_raw_bias_pol = (data_source("RAW_BIAS_POL")
                    .with_classification_rule(cls_zpl_bias_pol)
                    .with_setup_keywords(rules.setupkwd_zpl_bias)
                    .with_grouping_keywords(rules.grpkwd_zpl_bias)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TEN_DAYS, level=0)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TWELVE_DAYS, level=1)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=UNLIMITED, level=3)
                    .build())

zpl_raw_dark_pol = (data_source("RAW_DARK_POL")
                    .with_classification_rule(cls_zpl_dark_pol)
                    .with_setup_keywords(rules.setupkwd_zpl_dark)
                    .with_grouping_keywords(rules.grpkwd_zpl_dark)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TEN_DAYS, level=0)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=TWELVE_DAYS, level=1)
                    .with_match_keywords(rules.matchkwd_zpl_det, time_range=UNLIMITED, level=3)
                    .build())

zpl_raw_flat_pol = (data_source("RAW_FLAT_POL")
                    .with_classification_rule(cls_zpl_flat_pol)
                    .with_setup_keywords(rules.setupkwd_zpl_flat)
                    .with_grouping_keywords(rules.grpkwd_zpl_flat)
                    .build())

# modem_eff = efficiency of the modulation-demodulation cycle of rows in ZIMPOL detector
zpl_raw_modem_eff = (data_source("RAW_MODEM_EFF")
                     .with_classification_rule(cls_zpl_modem_eff)
                     .with_setup_keywords(rules.setupkwd_zpl_flat)
                     .with_grouping_keywords(rules.grpkwd_zpl_flat)
                     .build())

zpl_raw_distortion_img = (data_source("RAW_LAMP_ASTROMETRY_IMG")
                          .with_classification_rule(cls_zpl_distortion_img)
                          .with_setup_keywords(rules.setupkwd_zpl_flat)
                          .with_grouping_keywords([kwd.tpl_start])
                          .build())

zpl_raw_std_pol0 = (data_source("RAW_STANDARD_POL0")
                    .with_classification_rule(cls_zpl_standard_pol0)
                    .with_setup_keywords(rules.setupkwd_zpl_science_obj)
                    .with_grouping_keywords(rules.grpkwd_zpl_science_obj)
                    .with_match_keywords([kwd.instrume, kwd.ins3_opti5_name, kwd.ins3_opti6_name],
                                         time_range=QUARTERLY, level=0)
                    .build())

zpl_raw_std_polhigh = (data_source("RAW_STANDARD_POLHIGH")
                       .with_classification_rule(cls_zpl_standard_polhigh)
                       .with_setup_keywords(rules.setupkwd_zpl_science_obj)
                       .with_grouping_keywords(rules.grpkwd_zpl_science_obj)
                       .with_match_keywords([kwd.instrume, kwd.ins3_opti5_name, kwd.ins3_opti6_name],
                                            time_range=QUARTERLY, level=0)
                       .build())

zpl_raw_science_center_pol = (data_source("RAW_STAR_CENTER_POL")
                              .with_classification_rule(cls_zpl_coronagraph_center_pol)
                              .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                              .with_grouping_keywords(rules.grpkwd_zpl_science_ctr_flx)
                              .with_match_keywords(rules.matchkwd_zpl_star_cal, time_range=SAME_NIGHT, level=0)
                              .build())

zpl_raw_science_flux_p1 = (data_source("RAW_SCIENCE_FLUX_P1")
                           .with_classification_rule(cls_zpl_science_flux_p1)
                           .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                           .with_grouping_keywords(rules.grpkwd_zpl_science_ctr_flx)
                           .with_match_keywords(rules.matchkwd_zpl_star_cal, time_range=SAME_NIGHT, level=0)
                           .build())

zpl_raw_science_p1 = (data_source("RAW_SCIENCE_P1")
                      .with_classification_rule(cls_zpl_science_p1)
                      .with_setup_keywords(rules.setupkwd_zpl_science_obj)
                      .with_grouping_keywords(rules.grpkwd_zpl_science_obj)
                      .build())

zpl_raw_science_flux_p2 = (data_source("RAW_SCIENCE_FLUX_P23")
                           .with_classification_rule(cls_zpl_science_flux_p2)
                           .with_setup_keywords(rules.setupkwd_zpl_science_ctr_flx)
                           .with_grouping_keywords(rules.grpkwd_zpl_science_ctr_flx)
                           .with_match_keywords(rules.matchkwd_zpl_star_cal, time_range=SAME_NIGHT, level=0)
                           .build())

zpl_raw_science_p2 = (data_source("RAW_SCIENCE_P23")
                      .with_classification_rule(cls_zpl_science_p2)
                      .with_setup_keywords(rules.setupkwd_zpl_science_obj)
                      .with_grouping_keywords(rules.grpkwd_zpl_science_obj)
                      .build())

# static calibrations
zpl_phot_star_table = (data_source("ZPL_PHOT_STAR_CATALOG")
                       .with_classification_rule(ZPL_PHOT_STAR_TABLE)
                       .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                       .build())

zpl_filter_table = (data_source("ZPL_FILTER_TABLE")
                    .with_classification_rule(ZPL_FILTER_TABLE)
                    .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                    .build())

zpl_pol_correct_table = (data_source("ZPL_POL_CORRECT_TABLE")
                         .with_classification_rule(ZPL_POL_CORRECT_TABLE)
                         .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                         .build())

zpl_polhigh_star_table = (data_source("ZPL_POLHIGH_STAR_TABLE")
                          .with_classification_rule(ZPL_POLHIGH_STAR_TABLE)
                          .with_match_keywords([kwd.instrume, kwd.seq_arm], time_range=IN_THE_PAST, level=0)
                          .build())
