from edps import (
    qc1calib, calchecker, task, subworkflow, science, qc0, FilterMode, ReportInput
)

from .zimpol_datasources import *

"""
# Naming conventions

- Classification rules for raw frames start with `cls_`
- Classification rules for products have the same name as the PRO.CATG
- DataSources start with `raw_`
- Tasks start with `task_zpl_`
"""


# --- Processing Tasks -----------------------------------------------------------------------------
# bias, dark, flat field
@subworkflow("zimpol_internal_calibrations_imaging", "")
def process_zpl_img_internal_calib_img():
    # --- Determination of bias level and read - out noise(monitoring only, not needed in science reduction) ----------
    task_zpl_bias_img = (task("zimpol_bias_imaging")
                         .with_recipe("sph_zpl_master_bias_imaging")
                         .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                         .with_report("sphere_master_bias", ReportInput.RECIPE_INPUTS_OUTPUTS)
                         .with_main_input(zpl_raw_bias_img)
                         .with_meta_targets([qc1calib])
                         .build())

    # --- Determination of dark current ------------------------------------------------------------------------------
    task_zpl_dark_img = (task("zimpol_dark_imaging")
                         .with_recipe("sph_zpl_master_dark_imaging")
                         .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                         .with_report("sphere_master_dark", ReportInput.RECIPE_INPUTS_OUTPUTS)
                         .with_main_input(zpl_raw_dark_img)
                         .with_meta_targets([qc1calib])
                         .build())

    # Determination of instrumental distortion from observations of pinhole mask
    # no pipeline support; kept as a placeholder
    # task_zpl_distortion_img = (task("zimpol_distortion_img")
    #                           .with_main_input(zpl_raw_distortion_img)
    #                           .with_meta_targets([calchecker])
    #                           .build())

    # --- Determination of pixel-to-pixel variation in sensitivity (quantum efficiency, filter defects, etc) ---------
    # different raw data may be needed to match the filters used in CAM2 and CAM2, therefore we have 2 tasks and
    # filter the products per camera
    task_zpl_flat_img_cam1 = (task("zimpol_flat_imaging_cam1")
                              .with_recipe("sph_zpl_intensity_flat_imaging")
                              .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                              .with_report("sphere_img_flat", ReportInput.RECIPE_INPUTS_OUTPUTS)
                              .with_main_input(zpl_raw_flat_img)
                              .with_meta_targets([qc1calib])
                              .with_output_filter(ZPL_INT_FLAT_FIELD_IMAGING_CAM1)
                              .build())

    task_zpl_flat_img_cam2 = (task("zimpol_flat_imaging_cam2")
                              .with_recipe("sph_zpl_intensity_flat_imaging")
                              .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                              .with_report("sphere_img_flat", ReportInput.RECIPE_INPUTS_OUTPUTS)
                              .with_main_input(zpl_raw_flat_img)
                              .with_meta_targets([qc1calib])
                              .with_output_filter(ZPL_INT_FLAT_FIELD_IMAGING_CAM2)
                              .build())

    return task_zpl_bias_img, task_zpl_dark_img, task_zpl_flat_img_cam1, task_zpl_flat_img_cam2


# Process standard star observations for zimpol imaging mode
@subworkflow("zimpol_standard_imaging", "")
def process_zimpol_standard_imaging(task_zpl_dark_img, task_zpl_flat_img_cam1, task_zpl_flat_img_cam2,
                                    task_zpl_bias_img):
    # --- process raw astrometric standard star field ----------------------------------------------------------
    task_zpl_std_astrometry_img = (task("zimpol_standard_astrometry_imaging")
                                   .with_recipe("sph_zpl_science_imaging")
                                   .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                                   .with_main_input(zpl_raw_astrometry_std_img)
                                   .with_associated_input(task_zpl_dark_img, [ZPL_MASTER_DARK_IMAGING_CAM1,
                                                                              ZPL_MASTER_DARK_IMAGING_CAM2], min_ret=0)
                                   .with_associated_input(task_zpl_flat_img_cam1, [ZPL_INT_FLAT_FIELD_IMAGING_CAM1],
                                                          min_ret=0, match_rules=rules.zpl_ff_cam1)
                                   .with_associated_input(task_zpl_flat_img_cam2, [ZPL_INT_FLAT_FIELD_IMAGING_CAM2],
                                                          min_ret=0, match_rules=rules.zpl_ff_cam2)
                                   .with_associated_input(zpl_filter_table, min_ret=1)
                                   .with_meta_targets([qc1calib, calchecker])
                                   .build())

    # --- Determine zeropoints using photometric standard star observations
    # Not used in science processing, monitoring only ----------------------------------------------
    task_zpl_std_flux_img = (task("zimpol_standard_flux_imaging")
                             .with_recipe("sph_zpl_science_imaging")
                             .with_report("sphere_rawdisp", ReportInput.RECIPE_INPUTS)
                             .with_main_input(zpl_raw_std_flux_img)
                             .with_associated_input(task_zpl_dark_img, [ZPL_MASTER_DARK_IMAGING_CAM1,
                                                                        ZPL_MASTER_DARK_IMAGING_CAM2], min_ret=0)
                             .with_associated_input(task_zpl_flat_img_cam1, [ZPL_INT_FLAT_FIELD_IMAGING_CAM1],
                                                    min_ret=1, match_rules=rules.zpl_ff_cam1)
                             .with_associated_input(task_zpl_flat_img_cam2, [ZPL_INT_FLAT_FIELD_IMAGING_CAM2],
                                                    min_ret=1, match_rules=rules.zpl_ff_cam2)
                             .with_associated_input(zpl_phot_star_table, min_ret=1)
                             .with_associated_input(zpl_filter_table, min_ret=1)
                             .with_associated_input(task_zpl_bias_img,
                                                    [ZPL_MASTER_BIAS_IMAGING_CAM1, ZPL_MASTER_BIAS_IMAGING_CAM2])
                             .with_meta_targets([qc1calib, calchecker])
                             .build())
    return task_zpl_std_astrometry_img, task_zpl_std_flux_img


@subworkflow("zimpol_science_imaging", "")
def process_zimpol_science_imaging(task_zpl_dark_img, task_zpl_flat_img_cam1, task_zpl_flat_img_cam2,
                                   task_zpl_coronagraph_center_img):
    # Determine flux of science target for coronagraphic data (telescope moved so that the star can be observed without
    # coronagraph)
    # Not used for science processing
    task_zpl_science_flux_img = (task("zimpol_science_flux_imaging")
                                 .with_recipe("sph_zpl_science_imaging")
                                 .with_main_input(zpl_raw_science_flux_img)
                                 .with_associated_input(task_zpl_dark_img, [ZPL_MASTER_DARK_IMAGING_CAM1,
                                                                            ZPL_MASTER_DARK_IMAGING_CAM2], min_ret=0)
                                 .with_associated_input(task_zpl_flat_img_cam1, [ZPL_INT_FLAT_FIELD_IMAGING_CAM1],
                                                        min_ret=0, match_rules=rules.zpl_ff_cam1)
                                 .with_associated_input(task_zpl_flat_img_cam2, [ZPL_INT_FLAT_FIELD_IMAGING_CAM2],
                                                        min_ret=0, match_rules=rules.zpl_ff_cam2)
                                 .with_associated_input(zpl_filter_table, min_ret=0)
                                 .with_meta_targets([qc0, science, calchecker])
                                 .build())
    # Actual science data, may be observed with or without coronagraph
    task_zpl_science_img = (task("zimpol_science_imaging")
                            .with_recipe("sph_zpl_science_imaging")
                            .with_main_input(zpl_raw_science_img)
                            .with_associated_input(task_zpl_dark_img,
                                                   [ZPL_MASTER_DARK_IMAGING_CAM1, ZPL_MASTER_DARK_IMAGING_CAM2],
                                                   min_ret=0)
                            .with_associated_input(task_zpl_flat_img_cam1, [ZPL_INT_FLAT_FIELD_IMAGING_CAM1], min_ret=0,
                                                   match_rules=rules.zpl_ff_cam1)
                            .with_associated_input(task_zpl_flat_img_cam2, [ZPL_INT_FLAT_FIELD_IMAGING_CAM2], min_ret=0,
                                                   match_rules=rules.zpl_ff_cam2)
                            .with_associated_input(task_zpl_coronagraph_center_img, [ZPL_STAR_CENTER_IMG_CAM1,
                                                                                     ZPL_STAR_CENTER_IMG_CAM2],
                                                   min_ret=0)
                            .with_associated_input(task_zpl_science_flux_img, min_ret=0)
                            .with_input_filter(ZPL_SCIENCE_IMAGING_REDUCED_CAM1, ZPL_SCIENCE_IMAGING_REDUCED_CAM2,
                                               mode=FilterMode.REJECT)
                            .with_associated_input(zpl_filter_table, min_ret=0)
                            .with_meta_targets([qc0, science, calchecker])
                            .build())
    return task_zpl_science_img, task_zpl_science_flux_img
