AC_DEFUN([AB_EXTRA_PATH],
[
   AC_ARG_WITH([extra-include-dir],
      AC_HELP_STRING([--with-extra-include-dir=DIR], [extra headers are in DIR]),
      ac_with_extra=$withval
      if test "x${ac_with_extra}" != xyes && test "x${ac_with_extra}" != xno; then
            CPPFLAGS="-I$withval $CPPFLAGS"
      fi
   )

   AC_ARG_WITH([extra-lib-dir],
      AC_HELP_STRING([--with-extra-lib-dir=DIR], [extra libraries are in DIR]),
      ac_with_extra=$withval
      if test "x${ac_with_extra}" != xyes && test "x${ac_with_extra}" != xno; then
            LDFLAGS="-L$withval $LDFLAGS"
      fi
   )
])

AC_DEFUN([AB_DEBUG],
[
AC_ARG_ENABLE(debug,
              AC_HELP_STRING([--disable-debug], 
                             [Build without -DDEBUG -O2 -Wall (default on)]),
              [ac_request_debug=$enableval], 
              [ac_request_debug=yes])

if test "x$ac_request_debug" = xyes; then
   AC_MSG_NOTICE(Build with -DDEBUG -Wall)
   CPPFLAGS="$CPPFLAGS -DDEBUG -Wall"
   CFLAGS="-g $CFLAGS"
   CXXFLAGS="-g $CXXFLAGS"
fi
])
