/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IFS_KEYWORDS_H_
#define SPH_IFS_KEYWORDS_H_
/*---------------------------------------------------------------------------*/
/*
 * The keywords and corresponding allowed values for IFS are
 * defined in this file.
 * Keywords and values common to all SPHERE instruments are
 * defined in the common API under src/Sphere/sph_common_keywords.h
 */
/*---------------------------------------------------------------------------*/

#define SPH_IFS_KEYWORD_CORONO_SETTING					       "ESO DRS IFS CORONO"

#define SPH_IFS_KEYWORD_RAW_CORONO_SETTING          "ESO INS COMB ICOR"
#define SPH_IFS_KEYWORD_VALUE_RAW_CORONO_CLEAR      "N_NS_CLEAR"
#define SPH_IFS_KEYWORD_VALUE_RAW_DPR_FLUX          "OBJECT,FLUX"

#define SPH_IFS_KEYWORD_LAMP1_ID                    "ESO INS2 LAMP1 ID"
#define SPH_IFS_KEYWORD_LAMP2_ID                    "ESO INS2 LAMP2 ID"
#define SPH_IFS_KEYWORD_LAMP3_ID                    "ESO INS2 LAMP3 ID"
#define SPH_IFS_KEYWORD_LAMP4_ID                    "ESO INS2 LAMP4 ID"
#define SPH_IFS_KEYWORD_LAMP5_ID                    "ESO INS2 LAMP5 ID"
#define SPH_IFS_KEYWORD_LAMP6_ID                    "ESO INS2 LAMP6 ID"
#define SPH_IFS_KEYWORD_LAMP1_SWITCH                "ESO INS2 LAMP1 ST"
#define SPH_IFS_KEYWORD_LAMP2_SWITCH                "ESO INS2 LAMP2 ST"
#define SPH_IFS_KEYWORD_LAMP3_SWITCH                "ESO INS2 LAMP3 ST"
#define SPH_IFS_KEYWORD_LAMP4_SWITCH                "ESO INS2 LAMP4 ST"
#define SPH_IFS_KEYWORD_LAMP5_SWITCH                "ESO INS2 LAMP5 ST"
#define SPH_IFS_KEYWORD_LAMP6_SWITCH                "ESO INS2 LAMP6 ST"

#define SPH_IFS_KEYWORD_DMS_POS_X                             "ESO INS2 PAC X"
#define SPH_IFS_KEYWORD_DMS_POS_Y                             "ESO INS2 PAC Y"

//descr Number of spectra found
#define SPH_IFS_KEYWORD_SPECPOS_QC_NREGS_COMMENT              "Number of spectra found [1]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_NREGS                      "ESO QC NUMBER SPECTRA"
//descr Threshold used for spectra detection
#define SPH_IFS_KEYWORD_SPECPOS_QC_THRESHOLD_COMMENT          "Threshold used for spectra detection [ADU]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_THRESHOLD                  "ESO QC THRESHOLD USED"
//descr Number of pixels illuminated outside spectra
#define SPH_IFS_KEYWORD_SPECPOS_QC_PIXS_OUT_COMMENT           "Number of pixels illuminated outside spectra [1]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_PIXS_OUT                   "ESO DRS NUM ILLUM PIXELS OUT"
//descr Number of pixels illuminated inside spectra
#define SPH_IFS_KEYWORD_SPECPOS_QC_PIXS_IN_COMMENT            "Number of pixels illuminated inside spectra [1]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_PIXS_IN                    "ESO DRS NUM ILLUM PIXELS IN"
//descr Number of dark pixels inside spectra
#define SPH_IFS_KEYWORD_SPECPOS_QC_DARK_PIXS_IN_COMMENT       "Number of dark pixels inside spectra [1]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_DARK_PIXS_IN               "ESO DRS NUM DARK PIXELS IN"
//descr Scale of specpos model as measured
#define SPH_IFS_KEYWORD_SPECPOS_QC_SCALE_COMMENT              "Scale of specpos model as measured [1]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_SCALE                      "ESO QC SCALE MEASURED"
//descr X offset of specpos model as measured
#define SPH_IFS_KEYWORD_SPECPOS_QC_OFFSETX_COMMENT            "X offset of specpos model as measured [px]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_OFFSETX                    "ESO DRS OFFSETX MEASURED"
//descr Y offset of specpos model as measured
#define SPH_IFS_KEYWORD_SPECPOS_QC_OFFSETY_COMMENT            "Y offset of specpos model as measured [px]"
#define SPH_IFS_KEYWORD_SPECPOS_QC_OFFSETY                    "ESO DRS OFFSETY MEASURED"

//descr Smoothing length applied to BG
#define SPH_IFS_KEYWORD_CAL_BG_QC_SMOOTHING_LENGTH_COMMENT    "Smooting length applied to BG [px]"
#define SPH_IFS_KEYWORD_CAL_BG_QC_SMOOTHING_LENGTH            "ESO DRS BG SMOOTHING LENGTH"
//descr Background mean value
#define SPH_IFS_KEYWORD_CAL_BG_QC_MEAN_COMMENT                "background mean value [ADU]"
#define SPH_IFS_KEYWORD_CAL_BG_QC_MEAN                        "ESO QC BACKGROUND MEAN"
//descr Bckground RMS
#define SPH_IFS_KEYWORD_CAL_BG_QC_RMS_COMMENT                 "Background RMS [ADU]"
#define SPH_IFS_KEYWORD_CAL_BG_QC_RMS                         "ESO QC BACKGROUND RMS"
//descr Background median value
#define SPH_IFS_KEYWORD_CAL_BG_QC_MEDIAN_COMMENT              "Background median value [ADU]"
#define SPH_IFS_KEYWORD_CAL_BG_QC_MEDIAN                      "ESO QC BACKGROUND MEDIAN"

//descr Bench temperature
//comment: Bench temperature
#define SPH_IFS_KEYWORD_BENCH_TEMP                            "ESO INS4 TEMP2 VAL"

//descr Mean value of preamp correlation
#define SPH_IFS_KEYWORD_PREAMPCORR_MEAN_COMMENT                "Mean value of preamp correlation [1]"
#define SPH_IFS_KEYWORD_PREAMPCORR_MEAN                        "ESO QC PREAMP CORR MEAN"
//descr Median value of preamp correlation
#define SPH_IFS_KEYWORD_PREAMPCORR_MEDIAN_COMMENT              "Median value of preamp correlation [1]"
#define SPH_IFS_KEYWORD_PREAMPCORR_MEDIAN                      "ESO QC PREAMP CORR MEDIAN"
//descr RMS of preamp correlation
#define SPH_IFS_KEYWORD_PREAMPCORR_RMS_COMMENT                 "RMS of preamp correlation [1]"
#define SPH_IFS_KEYWORD_PREAMPCORR_RMS                         "ESO QC PREAMP CORR RMS"

//descr Number of points observed for distortion map
#define SPH_IFS_KEYWORD_DISTMAP_NPOINTS_OBS_COMMENT     "Number of points observed for distortion map [1]"
#define SPH_IFS_KEYWORD_DISTMAP_NPOINTS_OBS             "ESO QC DISTMAP NPOINTS OBS"

//descr Number of points used for distortion map
#define SPH_IFS_KEYWORD_DISTMAP_NPOINTS_IN_COMMENT      "Number of points used for distortion map [1]"
#define SPH_IFS_KEYWORD_DISTMAP_NPOINTS_IN              "ESO DRS DISTMAP NPOINTS IN"
//descr X position of optical axis for distortion map
#define SPH_IFS_KEYWORD_DISTMAP_OPTICAL_AXIS_X_COMMENT  "X position of optical axis for distortion map [px]"
#define SPH_IFS_KEYWORD_DISTMAP_OPTICAL_AXIS_X          "ESO DRS DISTMAP OPT AXIS X"
//descr Y position of optical axis for distortion map
#define SPH_IFS_KEYWORD_DISTMAP_OPTICAL_AXIS_Y_COMMENT  "Y position of optical axis for distortion map [px]"
#define SPH_IFS_KEYWORD_DISTMAP_OPTICAL_AXIS_Y          "ESO DRS DISTMAP OPT AXIS Y"
//descr Red. chi squared of the polynomial distortion fit
#define SPH_IFS_KEYWORD_DISTMAP_POLFIT_CHIX_COMMENT      "Chi squared of the polynomial distortion fit [1]"
#define SPH_IFS_KEYWORD_DISTMAP_POLFIT_CHIX              "ESO QC DISTMAP POLFIT CHIX"
//descr Red. chi squared of the polynomial distortion fit
#define SPH_IFS_KEYWORD_DISTMAP_POLFIT_CHIY_COMMENT      "Chi squared of the polynomial distortion fit [1]"
#define SPH_IFS_KEYWORD_DISTMAP_POLFIT_CHIY              "ESO QC DISTMAP POLFIT CHIY"

#define SPH_IFS_KEYWORD_ROT_ANGLE                       "ESO DRS IFS ROTANGLE"

#define SPH_IFS_KEYWORD_PRISM_MODE                      "ESO INS2 OPTI2 NAME"
#define SPH_IFS_KEYWORD_VALUE_PRISM_MODE_J              "PRI_YJ"
#define SPH_IFS_KEYWORD_VALUE_PRISM_MODE_JH             "PRI_YJH"

#define SPH_IFS_KEYWORD_VALUE_CORONO_SETTING_OUT	           "OUT"
#define SPH_IFS_KEYWORD_VALUE_CORONO_SETTING_IN		           "IN"

#define SPH_IFS_KEYWORD_VALUE_DPR_TYPE_DARK                   "DARK"
#define SPH_IFS_KEYWORD_VALUE_DPR_TECH_DARK                   "IMAGE"
#define SPH_IFS_KEYWORD_VALUE_DPR_CATG_DARK                   "CALIB"

#define SPH_IFS_KEYWORD_VALUE_DPR_TYPE_DFF                    "FLAT,LAMP"
#define SPH_IFS_KEYWORD_VALUE_DPR_TECH_DFF                    "IMAGE"
#define SPH_IFS_KEYWORD_VALUE_DPR_CATG_DFF                    "CALIB"

#define SPH_IFS_KEYWORD_VALUE_DPR_TYPE_IFSFLAT                "FLAT,LAMP"
#define SPH_IFS_KEYWORD_VALUE_DPR_TECH_IFSFLAT                "IFU"
#define SPH_IFS_KEYWORD_VALUE_DPR_CATG_IFSFLAT                "CALIB"

#define SPH_IFS_KEYWORD_VALUE_DPR_TYPE_WAVECALIB              "LAMP,WAVE"
#define SPH_IFS_KEYWORD_VALUE_DPR_TECH_WAVECALIB              "IFU"
#define SPH_IFS_KEYWORD_VALUE_DPR_CATG_WAVECALIB              "CALIB"

#define SPH_IFS_KEYWORD_VALUE_DPR_TYPE_RON              "DARK"
#define SPH_IFS_KEYWORD_VALUE_DPR_TECH_RON              "IMAGE"
#define SPH_IFS_KEYWORD_VALUE_DPR_CATG_RON              "CALIB"

#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_PIXEL_LINEARITY        "PIXEL_LINEARITY_MAP"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_PIXEL_DESCRIPTION_TAB  "PIXEL_DESCRIPTION_TABLE"

#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_MASTER_DARK            "IFS_MASTER_DARK"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_RON            		   "IFS_RON"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_MASTER_DFF             "IFS_MASTER_DFF"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_MASTER_FLAT            "IFS_MASTER_FLAT"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_STATIC_BADPIXELMAP     "IFS_STATIC_BADPIXELMAP"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_LINEAR_BADPIXELMAP     "IFS_LINEAR_BADPIXELMAP"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_PDT_MASK               "PIXEL_DESCRIPTION_TABLE"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_FFLAMP_SPECTRUM        "FFLAMP_SPECTRUM"
#define SPH_IFS_KEYWORD_VALUE_PRO_CATG_SCIENCE_DR        		"SCIENCE_DR"

/* PIPE-9314 - Keywords for tracking spectrum resolving power */
#define SPH_IFS_KEYWORD_LASER_LINE_FLUX         "ESO QC FLUX LASER"
#define SPH_IFS_KEYWORD_LASER_RESOVLING_POWER   "ESO QC RESPOW LASER"
#define SPH_IFS_KEYWORD_LASER_WAVELENGTH        "ESO QC LAM LASER"
#define SPH_IFS_KEYWORD_LASER_MIN_LAMBDA        "ESO QC MIN LAMBDA"
#define SPH_IFS_KEYWORD_LASER_DISPERSION        "ESO QC DISPERSION"
// PIPE-7454 - QC RESOLUTION RMS
#define SPH_IFS_KEYWORD_LASER_DISPERSION_RMS    "ESO QC DISPERSION RMS"

/* END PIPE-9314 */

/* sph_ifs_master_dark */

#endif /* SPH_IFS_KEYWORDS_H_ */
