/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ird_instrument_flat.h"
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"
#include "sph_ird_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IRD_INSTRUMENT_FLAT_GENERAL              = SPH_IRD_INSTRUMENT_FLAT_ERR_START + 0;
sph_error_code SPH_IRD_INSTRUMENT_FLAT_NO_VALID_DIT_LIST    = SPH_IRD_INSTRUMENT_FLAT_ERR_START + 1;

sph_error_code SPH_IRD_INSTRUMENT_FLAT_PARAMETER_MISSING    = SPH_IRD_INSTRUMENT_FLAT_ERR_START + 3;
sph_error_code SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING       = SPH_IRD_INSTRUMENT_FLAT_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ird_instrument_flat_create_plugin ( cpl_plugin * );
static int sph_ird_instrument_flat_exec_plugin ( cpl_plugin * );
static int sph_ird_instrument_flat_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ird_instrument_flat_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IRD_FLAT_FIELD_RAW              2,500   The input raw flat frames. To be taken with different illumination levels.\n"
    "IRD_MASTER_DARK                 0,  1   A master dark frame. Should have the same DIT and\n"
    "                                        readout mode as the science frame(s)\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames, but one of the MUST be present!\n"
    "IRD_INS_BG                      0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s).\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames, but one of the MUST be present!\n"
    "IRD_INS_BG_FIT                  0,  1   An instrument background frame. Should have the same DIT, filter, and\n"
    "                                        readout mode as the science frame(s)\n"
    "                                        Note that this frame is optional as are the other possible\n"
    "                                        dark/background frames, but one of the MUST be present!\n"
    "IRD_DARK_RAW                    0,500   The  dark (background) frames. Should have one dark for each DIT and readout mode of\n"
    "                                        the flat raw frames.  The latter is the reason for not accepting finalized\n"
    "                                        IRD_MASTER_DARK frames, but creating them on the fly!\n"
    "IRD_STATIC_BADPIXELMAP          0,  1   Optional frame of static bad pixels. If provided, this is used in addtion to\n"
    "                                        the badpixels from the master dark. This frame can also be used to select out\n"
    "                                        specific regions on the detector for which a flat field should be determined\n"
    "                                        at all -- to exclude for example problematic regions know to be affect e.g. by\n"
    "                                        vignetting.\n"
    "IRD_INSTRUMENT_MODEL            0,  1   Optional frame describing a non-default IRDIS instrument model.\n"
    "                                        This is an ini style ASCII frame. See the manual for the format.\n"
    "                                        Please use this input only after consulting a DRH developer.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "The instrument flat field recipe for IRDIS is very similar as the detector flat\n"
    "field recipe for IFS, sph_ifs_detector_flat_field.\n"
    "\n"
    "The flat recipe as described here uses input exposures taken with the\n"
    "narraw band or broad band calibration lamps in any of the IRDIS modes.\n"
    "This flat is used in all\n"
    "subsequent recipes that need to remove the pixel to pixel variation in the\n"
    "signal response of the detector and instrument. It is therefore important that\n"
    "input frames are consistently for one particular instrument configuration and that\n"
    "the resulting flat is applied only to data taken with matching instrument configurations.\n"
    "\n"
    "As input the recipe requires a series of flat exposures with different median count levels.\n"
    "This may either be achieved by varying the lamp intensity (preferred) or more commonly by varying\n"
    "the exposure time.\n"
    "\n"
    "Dark handling in this recipe is special: For best results, the recipe needs a series of raw dark\n"
    "frames with DITs matching those of the raw flat field frames. If raw darks are provided, the recipe\n"
    "will for each raw flat field frame select the raw dark with the closest matching DIT and subtract\n"
    "it. the recipe will not insist on perfectly matching DITs, this is the user's responsibility!\n"
    "\n"
    "If raw darks are unavailble (e.g. in a automated pipeline context), the recipe can also apply\n"
    "standard irdis background frames. Note that in this case a single dark frame will be subtracted\n"
    "from all input frames. Best results can thus be achieved only if all input raw flat fields have the\n"
    "same DIT (matching that of the background, of course) and lamp intensity is varied to achieve variable flux.\n"
    "\n"
    "The order of selecting what actually happens is the following:\n"
    "\n"
    "1.  If raw darks are available, all others are ignored.\n"
    "\n"
    "2.  Else if an INS_BG_FIT is available, this one is chosen.\n"
    "\n"
    "3.  Else if an INS_BG is available, this one is chosen.\n"
    "\n"
    "4.  Else if a MASTER_DARK is available, this one is chosen.\n"
    "\n"
    "\n"
    "\n"
    "The recipe will also run without any dark at all!  It is thus the user's responsibility to supply adequate\n"
    "background frames to achieve the best possible results!\n"
    "\n"
    "The recipe creates the flats as follows:\n"
    "All raw frames are read in and dark subtracted. The dark subtraction is performed differently than for other\n"
    "recipes, and rather than master darks, the recipe actually uses raw dark or background frames. Since the\n"
    "background varies significantly depending on the chosen detector integration time, a dark with a matching exposure time\n"
    "needs to be subtracted for each flat.\n"
    "If a specific irdis instrument model\n"
    "is provided via an input frame the irdis instrument model is read from that frame,\n"
    "otherwise a default model is used. This model is used to identifiy the left and right\n"
    "detector windows.\n"
    "In the next step, a mask of the illuminated region is created by combining all input exposures\n"
    "and using a thresholding above the given input threshold value to identify illuminated regions\n"
    "and masking out non-illuminated regions. Any hot pixels known from the master dark\n"
    "or the provided hotpixel mask are also masked out.\n"
    "The flat fielding procedure descibed below (identical to that for the\n"
    "IFS) is then\n"
    "\n"
    "applied to the left and right windows <span>**seperately**</span>.\n"
    "\n"
    "1.  The mean value is determined for the respective window for\n"
    "\n"
    "    all exposures.\n"
    "\n"
    "2.  For every pixel $p=(x,y)$, a set of $m_i$,$v_i(x,y)$ data pairs\n"
    "\n"
    "    are stored with $m_i$ being the exposure mean value and $v_i(x,y)$\n"
    "\n"
    "    being the pixel value for exposure $i$.\n"
    "\n"
    "3.  The flat field value of pixel $p(x,y)$ is defined as the\n"
    "\n"
    "    slope $c(x,y)$ of a linear fit F to the data $m_i$,$v_i(x,y)$.\n"
    "\n"
    "4.  This slope $c(x,y)$ effectively represents the pixel’s response to\n"
    "\n"
    "    illumination relative to the detector mean response. It\n"
    "    <span>*is*</span> the flat\n"
    "\n"
    "    field value and comes naturally out of the procedure being close to\n"
    "    1.\n"
    "\n"
    "5.  The fit itself is performed either using a maximum likelyhood method\n"
    "\n"
    "    or a robust fitting method which minimizes the sum of the absolute\n"
    "    value of\n"
    "\n"
    "    the deviations rather than the sum of the squares of the deviations\n"
    "\n"
    "    (see e.g. Numerical Recipes for the algorithm). The robust fitting\n"
    "    method will\n"
    "\n"
    "    yield better results when significant outliers (e.g. due to cosmic\n"
    "    rays) can\n"
    "\n"
    "    be expected.\n"
    "\n"
    "6.  The flat field values are saved as an image as the main product of\n"
    "    the recipe.\n"
    "\n"
    "\n"
    "\n"
    "Aditionally, the recipe may also produce a separate output of all pixels that\n"
    "are identified as non-linear. The criteria for non-linearity are set by the user\n"
    "parameters and can be either pixels that have a flat field value outside specified\n"
    "bounds and/or pixels for which the linear fit produces a reduced chi-squared above\n"
    "a given threshold value. Note that non-linearity pixel determination is performed\n"
    "on the entire detector region and not the left and right window seperately.\n"
    "For reliable non-linearity flagging using the reduced chi-squared\n"
    "it is necessary to use many high quality input exposures.\n"
    "Since the badpixel treatment is somewhat complicated, some important points: the badpixels\n"
    "that are stored in the master flat field itself as produced by this recipe (the second extension\n"
    "of the main recipe product) contain all the badpixels at this point in the cascade. Pixels that\n"
    "were marked as bad from the input static badpixel map are also marked\n"
    "as bad here.\n"
    "The optional static badpixel output that is produced contains strictly only those pixel that the\n"
    "flat field recipe itself deemed to be bad. This does not necessarily include all the badpixels\n"
    "from the static badpixel input file.\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IRD_FLAT_FIELD                     FITS[Im(4)]    The flat field. This is saved as a FITS file with 4 extensions, the flat values,\n"
    "                                        the badpixels (hotpixels and non-linear pixels), a weight map (number of frames\n"
    "                                        that contributed to each pixel), and the rms\n"
    "IRD_STATIC_BADPIXELMAP             FITS[Im(1)]    Optional output of all the non-linear pixels determined. All pixels as determined\n"
    "                                        in this recipe using the ird.instrument_flat.badpix_ tolerance parameters.\n"
    "                                        This map does NOT include all the dark frame badpixels -- it really only includes\n"
    "                                        those badpixels that are bad simply due to the flat field criteria.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_instrument_flat Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_instrument_flat.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IRD_INSTRUMENT_FLAT_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ird_instrument_flat",
                        "Determine the instrument flat field",
                        sph_ird_instrument_flat_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "anonymous", cpl_get_license("SPHERE DRH","2012"),
                        sph_ird_instrument_flat_create_plugin,
                        sph_ird_instrument_flat_exec_plugin,
                        sph_ird_instrument_flat_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_instrument_flat_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ird_instrument_flat_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IRD_INSTRUMENT_FLAT_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ird_instrument_flat_create_test(cpl_plugin * plugin)
{
    return (int)sph_ird_instrument_flat_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_instrument_flat_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ird_instrument_flat*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ird_instrument_flat_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ird_instrument_flat_run( sph_recipe );

        sph_ird_instrument_flat_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_instrument_flat_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ird_instrument_flat struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ird_instrument_flat_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ird.instrument_flat.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.instrument_flat",
                                   "irdis_flat.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.robust_fit",
                                   CPL_TYPE_BOOL,
                                   "Controls if fitting method is to be a robust linear fit. This will reduce the effect of cosmic "
                                   "rays and other temporary bad pixels. See e.g. Numerical Recipes for a description of the algorithm "
                                   ,"ird.instrument_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.instrument_flat.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean. This affects only the first "
                                   "processing step, where the illuminated region is determined. It does not affect the actual flat value "
                                   "determination. "
                                   ,"ird.instrument_flat",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.instrument_flat.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. This affects only the first "
                                   "processing step, where the illuminated region is determined. It does not affect the actual flat value "
                                   "determination. "
                                   ,"ird.instrument_flat",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.instrument_flat.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. This affects only the first "
                                   "processing step, where the illuminated region is determined. It does not affect the actual flat value "
                                   "determination. "
                                   ,"ird.instrument_flat",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.save_addprod",
                                   CPL_TYPE_BOOL,
                                   "Controls if additional products, in this case a badpixel "
                                   "map should be created. "
                                   ,"ird.instrument_flat",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.badpixfilename",
                                   CPL_TYPE_STRING,
                                   "Controls the filename of the badpixel map, if requested for output. Ignored if no make_badpix is FALSE. "
                                   ,"ird.instrument_flat",
                                   "instr_flat_badpixels.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.badpix_lowtolerance",
                                   CPL_TYPE_DOUBLE,
                                   "The minimum linear threshold value thats acceptable. "
                                   "All pixels in the final flat that have values below this value will be marked "
                                   "as bad. "
                                   ,"ird.instrument_flat",
                                   0.1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.badpix_uptolerance",
                                   CPL_TYPE_DOUBLE,
                                   "The maximum linear threshold value thats acceptable. "
                                   "All pixels in the final flat that have values above this value will be marked "
                                   "as bad. "
                                   ,"ird.instrument_flat",
                                   10.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.badpix_chisqtolerance",
                                   CPL_TYPE_DOUBLE,
                                   "The maximum error value thats acceptable. "
                                   "All pixels in the final flat that have errors above this value will be marked "
                                   "as bad. "
                                   ,"ird.instrument_flat",
                                   50.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.instrument_flat.threshold",
                                   CPL_TYPE_DOUBLE,
                                   "The thresholding to use to detect illuminated regions. Before the flat is determined all pixels "
                                   "that have counts below a value of the threshold times the mean are masked out. "
                                   "Note that this should only give a very rough masking. It is much preferable to select "
                                   "the regions for flat determination using the static badpixel input frame. "
                                   ,"ird.instrument_flat",
                                   0.1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ird_instrument_flat_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ird_instrument_flat_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ird_instrument_flat
           structure.
 @param    self     the sph_ird_instrument_flat recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ird_instrument_flat_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ird_instrument_flat_check_frames( sph_ird_instrument_flat* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FLAT_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_FLAT_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FLAT_RAW);
        rerr = SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
          if ( numframes < 2) {
              sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                  __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                  "Not enough frames in frameset SPH_IRD_TAG_FLAT_RAW. "
                  "Was expecting at least 2 but only got %d. ",
              numframes);
              return CPL_ERROR_ILLEGAL_INPUT;
          }
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    if ( ! self->master_dark )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_CALIB );
    if ( ! self->insbg_frame )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->insbg_fit_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INS_BG_FIT_CALIB );
    if ( ! self->insbg_fit_frame )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract insbg_fit_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INS_BG_FIT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->insbg_fit_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DARK_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frameset = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_DARK_RAW );
    if ( ! self->master_dark_frameset )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frameset frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DARK_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->master_dark_frameset );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->master_dark_frameset, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->master_dark_frameset );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    if ( ! self->static_badpixel_frame )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract static_badpixel_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INSTRUMENT_MODEL );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->model_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INSTRUMENT_MODEL );
    if ( ! self->model_frame )
    {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract model_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INSTRUMENT_MODEL);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->model_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ird_instrument_flat
           structure.
 @param    self     the sph_ird_instrument_flat recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ird_instrument_flat_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_instrument_flat_check_params( sph_ird_instrument_flat* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.outfilename");
    }

    self->outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.robust_fit");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.robust_fit");
    }

    self->robust_fit = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.save_addprod");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.save_addprod");
    }

    self->save_addprod = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.badpixfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.badpixfilename");
    }

    self->badpix_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.badpix_lowtolerance");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.badpix_lowtolerance");
    }

    self->badpix_lowtolerance = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.badpix_uptolerance");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.badpix_uptolerance");
    }

    self->badpix_uptolerance = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.badpix_chisqtolerance");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.badpix_chisqtolerance");
    }

    self->badpix_chisqtolerance = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.instrument_flat.threshold");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.instrument_flat.threshold");
    }

    self->threshold = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ird_instrument_flat structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ird_instrument_flat_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ird_instrument_flat* sph_ird_instrument_flat_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ird_instrument_flat*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ird_instrument_flat) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IRD_INSTRUMENT_FLAT_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ird_instrument_flat_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ird_instrument_flat_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ird_instrument_flat_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ird_instrument_flat structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ird_instrument_flat_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_instrument_flat_delete( sph_ird_instrument_flat* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->master_dark != NULL ) {
        cpl_frame_delete( self->master_dark );
        self->master_dark = NULL;
    }
    if ( self->insbg_frame != NULL ) {
        cpl_frame_delete( self->insbg_frame );
        self->insbg_frame = NULL;
    }
    if ( self->insbg_fit_frame != NULL ) {
        cpl_frame_delete( self->insbg_fit_frame );
        self->insbg_fit_frame = NULL;
    }
    if ( self->master_dark_frameset != NULL ) {
        cpl_frameset_delete( self->master_dark_frameset );
        self->master_dark_frameset = NULL;
    }
    if ( self->static_badpixel_frame != NULL ) {
        cpl_frame_delete( self->static_badpixel_frame );
        self->static_badpixel_frame = NULL;
    }
    if ( self->model_frame != NULL ) {
        cpl_frame_delete( self->model_frame );
        self->model_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
