/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_IRD_WAVE_CALIB_H_

#define SPH_IRD_WAVE_CALIB_H_
#define SPH_IRD_WAVE_CALIB_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_ird_wave_calib that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_ird_wave_calib_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     outfilename                           ; /* The parameter of ird.wave_calib.outfilename */

    int                             coll_alg                              ; /* The parameter of ird.wave_calib.coll_alg */

    short                           use_inskeys                           ; /* The parameter of ird.wave_calib.use_inskeys */

    int                             clean_mean_reject_high                ; /* The parameter of ird.wave_calib.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of ird.wave_calib.clean_mean.reject_low */

    double                          threshold                             ; /* The parameter of ird.wave_calib.threshold */

    double                          smooth                                ; /* The parameter of ird.wave_calib.smooth */

    double                          wavelength_line1                      ; /* The parameter of ird.wave_calib.wavelength_line1 */

    double                          wavelength_line2                      ; /* The parameter of ird.wave_calib.wavelength_line2 */

    double                          wavelength_line3                      ; /* The parameter of ird.wave_calib.wavelength_line3 */

    double                          wavelength_line4                      ; /* The parameter of ird.wave_calib.wavelength_line4 */

    double                          wavelength_line5                      ; /* The parameter of ird.wave_calib.wavelength_line5 */

    double                          wavelength_line6                      ; /* The parameter of ird.wave_calib.wavelength_line6 */

    int                             line_tolerance                        ; /* The parameter of ird.wave_calib.line_tolerance */

    int                             number_lines                          ; /* The parameter of ird.wave_calib.number_lines */

    int                             fitorder                              ; /* The parameter of ird.wave_calib.degree */

    int                             column_w                              ; /* The parameter of ird.wave_calib.column_width */

    char*                           grism_mode                            ; /* The parameter of ird.wave_calib.grism_mode */

    double                          c2                                    ; /* The parameter of ird.wave_calib.c2 */

    double                          c3                                    ; /* The parameter of ird.wave_calib.c3 */

    double                          c4                                    ; /* The parameter of ird.wave_calib.c4 */

    cpl_frameset*                   rawframes                             ; /* The IRD_WAVECALIB_RAW frames */

    cpl_frame*                      bg_raw                                ; /* The IRD_INSTR_BG_RAW frames */

    cpl_frame*                      master_flat_frame                     ; /* The IRD_FLAT_FIELD frames */

    cpl_frame*                      master_dark_frame                     ; /* The IRD_MASTER_DARK frames */

    cpl_frame*                      mask_frame                            ; /* The IRD_STATIC_BADPIXELMAP frames */

    cpl_vector*                     calib_wavelengths                     ; /* The calib_wavelengths data field */

    sph_master_frame*               dark                                  ; /* The dark data field */

    sph_master_frame*               flat                                  ; /* The flat data field */

    sph_master_frame*               bgmframe                              ; /* The bgmframe data field */

    cpl_image*                      maskimage                             ; /* The maskimage data field */

    sph_master_frame*               rawmframe                             ; /* The rawmframe data field */

    cpl_propertylist*               qclist                                ; /* The qclist data field */

    sph_pixel_description_table*    pdt                                   ; /* The pdt data field */

    sph_ird_instrument_model*       model                                 ; /* The model data field */

} sph_ird_wave_calib;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_ird_wave_calib_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_ird_wave_calib.
 * 
 * ------------------------------------------------------------------------------
 */

sph_ird_wave_calib* sph_ird_wave_calib_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_ird_wave_calib_check_frames( sph_ird_wave_calib* self );

sph_error_code sph_ird_wave_calib_check_params( sph_ird_wave_calib* parlist );

cpl_error_code sph_ird_wave_calib_run( sph_ird_wave_calib* self );

sph_error_code sph_ird_wave_calib_delete( sph_ird_wave_calib* self );
cpl_parameterlist*  sph_ird_wave_calib_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_ird_wave_calib.c */


/* End of extra function declarations that are defined in sph_ird_wave_calib_run.c */



#endif /*SPH_IRD_WAVE_CALIB_H_*/
