/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_ZPL_MASTER_BIAS_H_

#define SPH_ZPL_MASTER_BIAS_H_
#define SPH_ZPL_MASTER_BIAS_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_zpl_master_bias that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_zpl_master_bias_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     master_bias_outfilename               ; /* The parameter of zpl.master_bias.outfilename */

    const char*                     master_bias_outfilename_cam1          ; /* The parameter of zpl.master_bias.outfilename_cam1 */

    const char*                     master_bias_outfilename_cam2          ; /* The parameter of zpl.master_bias.outfilename_cam2 */

    short                           subtract_overscan                     ; /* The parameter of zpl.master_bias.subtract_overscan */

    int                             coll_alg                              ; /* The parameter of zpl.master_bias.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of zpl.master_bias.coll_alg.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of zpl.master_bias.coll_alg.clean_mean.reject_low */

    double                          clean_mean_sigma                      ; /* The parameter of zpl.master_bias.clean_mean.sigma */

    double                          sigma_clip                            ; /* The parameter of zpl.master_bias.sigma_clip */

    short                           keep_intermediate                     ; /* The parameter of zpl.master_bias.keep_intermediate */

    const char*                     outfilename_cam1                      ; /* The parameter of zpl.preproc.outfilename_cam1 */

    const char*                     outfilename_cam2                      ; /* The parameter of zpl.preproc.outfilename_cam2 */

    cpl_frameset*                   rawframes                             ; /* The ZPL_BIAS_RAW frames */

    cpl_frameset*                   preproc_frames                        ; /* The ZPL_BIAS_PREPROC frames */

    cpl_frameset*                   preproc_frames_cam1                   ; /* The ZPL_BIAS_PREPROC_CAM1 frames */

    cpl_frameset*                   preproc_frames_cam2                   ; /* The ZPL_BIAS_PREPROC_CAM2 frames */

    sph_quad_image*                 master_bias_quadimage                 ; /* The ZPL_MASTER_BIAS product */

    sph_quad_image*                 master_bias_quadimage_cam1            ; /* The ZPL_MASTER_BIAS_CAM1 product */

    sph_quad_image*                 master_bias_quadimage_cam2            ; /* The ZPL_MASTER_BIAS_CAM2 product */

} sph_zpl_master_bias;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_zpl_master_bias_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_zpl_master_bias.
 * 
 * ------------------------------------------------------------------------------
 */

sph_zpl_master_bias* sph_zpl_master_bias_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_zpl_master_bias_check_frames( sph_zpl_master_bias* self );

sph_error_code sph_zpl_master_bias_check_params( sph_zpl_master_bias* parlist );

cpl_error_code sph_zpl_master_bias_run( sph_zpl_master_bias* self );

sph_error_code sph_zpl_master_bias_delete( sph_zpl_master_bias* self );
cpl_parameterlist*  sph_zpl_master_bias_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_zpl_master_bias.c */


/* End of extra function declarations that are defined in sph_zpl_master_bias_run.c */



#endif /*SPH_ZPL_MASTER_BIAS_H_*/
