/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_psfcube.h"
#ifndef SPH_ANDROMEDA_SUPPORT_H_
#define SPH_ANDROMEDA_SUPPORT_H_
#include "sph_andromeda_core.h"

cpl_bivector*
sph_andromeda_support_create_angpairs( cpl_vector* angles,
                                            double angmin,
                                            cpl_vector** waste )
    CPL_ATTR_ALLOC;
sph_andromeda_core*
sph_andromeda_support_init_core(
        cpl_imagelist* imlist,
        cpl_vector* angles,
        cpl_bivector* indices,
        sph_psfcube* psfcube)
    CPL_ATTR_ALLOC;

void sph_andromeda_core_delete(sph_andromeda_core*);
void sph_andromeda_core_dump(FILE*, const sph_andromeda_core*)
    CPL_ATTR_NONNULL;

sph_psfcube*
sph_andromeda_support_calc_psf_shift_subpix( cpl_image* image, int n )
    CPL_ATTR_ALLOC;
cpl_image*
sph_andromeda_support_cal_freq_image( int n, int m, double cx, double cy )
    CPL_ATTR_ALLOC;
cpl_image*
sph_andromeda_support_calc_mask_image( const cpl_image* distim,
        double rmin, double rmax )
    CPL_ATTR_ALLOC;
cpl_imagelist*
sph_andromeda_support_angular_difference( const cpl_imagelist* inlist,
        const cpl_imagelist* varilist,
        const cpl_vector* posind,
        const cpl_vector* negind,
        double rmin,
        double rmax,
        int least_sq,
        cpl_vector** ingamma,
        cpl_imagelist** varout,
        cpl_imagelist** weigthsout)
    CPL_ATTR_ALLOC;

cpl_vector*
sph_andromeda_support_calc_normalisations( const cpl_imagelist* inlist,
        const cpl_vector* posind,
        const cpl_vector* negind,
        double rmin,
        double rmax,
        int least_sq)
    CPL_ATTR_ALLOC;

cpl_image*
sph_andromeda_support_place_psfs( sph_andromeda_core* core, double gamma )
    CPL_ATTR_ALLOC;
sph_error_code
sph_andromeda_support_get_region(
        int x, int y,int i,
        sph_andromeda_core* core);
#endif /* SPH_ANDROMEDA_SUPPORT_H_ */
