/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_DATASET_H_
#define SPH_DATASET_H_
#include <cpl.h>

typedef struct _sph_dataset_
{
    int                     npoints;                
    cpl_vector*             xvalues;
    cpl_vector*             yvalues; 
} sph_dataset;


sph_dataset*
sph_dataset_new( int npoints, double minlambda, double maxlambda )
    CPL_ATTR_ALLOC;

sph_dataset*
sph_dataset_new_extract( const cpl_image* image, int minx, int miny,
                         int maxx, int maxy )
    CPL_ATTR_ALLOC;

sph_dataset*
sph_dataset_new_pixel_histogram( const cpl_image* image, double min, double max,
                                 int npoints )
    CPL_ATTR_ALLOC;
sph_dataset*
sph_dataset_load( const char* czFilename )
    CPL_ATTR_ALLOC;

int sph_dataset_collapse( sph_dataset* self, const cpl_image* im,
                          double minl, double maxl );

int sph_dataset_delete( sph_dataset* self);

int sph_dataset_save( sph_dataset* self, const char* filename );
double sph_dataset_get_value( const sph_dataset* self, double value );

int sph_dataset_add_value( sph_dataset* self, double xvalue, double toadd );

int sph_dataset_fit_gauss( const sph_dataset* self, double* x0, double* sigma,
                           cpl_vector* errs, double* chi );
double sph_dataset_get_max_xpos( const sph_dataset* self );

int sph_dataset_get_index( const sph_dataset* self, double value );

int sph_dataset_save_ascii( const sph_dataset* self, const char* filename);
#endif /*SPH_SPECTRUM_H_*/
