/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_FILEMANAGER_H_
#define SPH_FILEMANAGER_H_

typedef struct _sph_filemanager_
{
	char* workdir;
	char** tmpfiles;
	int ntmpfiles;
} sph_filemanager;

sph_filemanager*
sph_filemanager_new(void);
int sph_filemanager_is_fits( const char * filename );
void
sph_filemanager_add_tmp_file( const char* filename );
void sph_filemanager_clean(void);
char*
sph_filemanager_remove_dir( const char* filename )
    CPL_ATTR_ALLOC;
sph_error_code
sph_filemanager_split( const char* filename, char* base, char* ext );

const char * sph_filemanager_get_basename( const char*);

char*
sph_filemanager_get_tmp_filename( const char* filename )
    CPL_ATTR_ALLOC;

cpl_frame*
sph_filemanager_get_unique_duplicate_frame( const cpl_frame* inframe )
    CPL_ATTR_ALLOC;
char*
sph_filemanager_get_numbered_filename_new_file( const char* filename )
    CPL_ATTR_ALLOC;
char*
sph_filemanager_get_numbered_filename( const char* filename, int ii )
    CPL_ATTR_ALLOC;
char*
sph_filemanager_new_filename_from_base( const char* filename, const char* insert)
    CPL_ATTR_ALLOC;
char*
sph_filemanager_filename_new_ext( const char* filename, const char* ext)
    CPL_ATTR_ALLOC;

cpl_frame*	sph_filemanager_create_temp_frame( const char* filebase, const char* tag, cpl_frame_group group )
    CPL_ATTR_ALLOC;

void
sph_filemanager_delete(int noclean);

#endif /* SPH_FILEMANAGER_H_ */
